/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.util;

import java.util.regex.Pattern;

public final class Strings {
    private static final Pattern CHECK_ESCAPE = Pattern.compile("[,;\n\\\\]");
    private static final Pattern CHECK_UNESCAPE = Pattern.compile("\\\\");
    private static final Pattern ESCAPE_PATTERN_1 = Pattern.compile("([,;])");
    private static final Pattern ESCAPE_PATTERN_2 = Pattern.compile("\r?\n");
    private static final Pattern ESCAPE_PATTERN_3 = Pattern.compile("\\\\");
    private static final Pattern UNESCAPE_PATTERN_1 = Pattern.compile("\\\\([,;\"])");
    private static final Pattern UNESCAPE_PATTERN_2 = Pattern.compile("\\\\n", 2);
    private static final Pattern UNESCAPE_PATTERN_3 = Pattern.compile("\\\\\\\\");
    public static final Pattern PARAM_QUOTE_PATTERN = Pattern.compile("[:;,]");
    public static final String LINE_SEPARATOR = "\r\n";

    private Strings() {
    }

    public static String quote(Object aValue) {
        if (aValue != null) {
            return "\"" + aValue + "\"";
        }
        return "\"\"";
    }

    public static String unquote(String aValue) {
        if (aValue != null && aValue.startsWith("\"") && aValue.endsWith("\"")) {
            return aValue.substring(0, aValue.length() - 1).substring(1);
        }
        return aValue;
    }

    public static String escape(String aValue) {
        if (aValue != null && CHECK_ESCAPE.matcher(aValue).find()) {
            return ESCAPE_PATTERN_1.matcher(ESCAPE_PATTERN_2.matcher(ESCAPE_PATTERN_3.matcher(aValue).replaceAll("\\\\\\\\")).replaceAll("\\\\n")).replaceAll("\\\\$1");
        }
        return aValue;
    }

    public static String unescape(String aValue) {
        if (aValue != null && CHECK_UNESCAPE.matcher(aValue).find()) {
            return UNESCAPE_PATTERN_3.matcher(UNESCAPE_PATTERN_2.matcher(UNESCAPE_PATTERN_1.matcher(aValue).replaceAll("$1")).replaceAll("\n")).replaceAll("\\\\");
        }
        return aValue;
    }

    public static String valueOf(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }
}

