/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.io.CharConversionException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.autoupdate.ui.DetailsPanel;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public class UnitDetails
extends DetailsPanel {
    private final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.ui.UnitDetails");

    public UnitDetails() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTable.class, (String)"ACN_UnitDetails"));
    }

    public void setUnit(Unit unit) {
        this.setUnit(unit, null);
    }

    public void setUnit(Unit unit, Action action) {
        if (unit == null) {
            this.getDetails().setText("<i>" + UnitDetails.getBundle("UnitDetails_Category_NoDescription") + "</i>");
            this.setTitle(null);
        } else {
            Object object;
            String string;
            try {
                string = unit.annotate(XMLUtil.toElementContent((String)unit.getDisplayName()));
                this.setTitle(string);
                string = "";
                this.setActionListener(action);
                if (unit instanceof Unit.Available) {
                    object = (Unit.Available)unit;
                    UpdateUnitProvider.CATEGORY cATEGORY = ((Unit.Available)object).getSourceCategory();
                    String string2 = Utilities.getCategoryName(cATEGORY);
                    URL uRL = Utilities.getCategoryIcon(cATEGORY);
                    string = string + "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>";
                    string = string + "<td><img src=\"" + uRL.toExternalForm() + "\"></img></td>";
                    string = string + "<td>&nbsp;&nbsp;</td>";
                    string = string + "<td><b>" + string2 + "</b></td>";
                    string = string + "</tr></table><br>";
                }
                if (Utilities.modulesOnly() || Utilities.showExtendedDescription()) {
                    string = string + "<b>" + UnitDetails.getBundle("UnitDetails_Plugin_CodeName") + "</b>" + unit.annotate(unit.updateUnit.getCodeName());
                    string = string + "<br>";
                }
                string = string + "<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Version") + "</b>" + unit.annotate(unit.getDisplayVersion()) + "<br>";
                if (unit.getAuthor() != null && unit.getAuthor().length() > 0) {
                    string = string + "<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Author") + "</b>" + unit.annotate(unit.getAuthor()) + "<br>";
                }
                if (unit.getDisplayDate() != null && unit.getDisplayDate().length() > 0) {
                    string = string + "<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Date") + "</b>" + unit.annotate(unit.getDisplayDate()) + "<br>";
                }
                string = string + "<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Source") + "</b>" + unit.annotate(unit.getSource()) + "<br>";
                if (unit.getHomepage() != null && unit.getHomepage().length() > 0) {
                    string = string + "<b>" + UnitDetails.getBundle("UnitDetails_Plugin_Homepage") + "</b><a href=\"" + unit.getHomepage() + "\">" + unit.annotate(unit.getHomepage()) + "</a><br>";
                }
                if (unit.getNotification() != null && unit.getNotification().length() > 0) {
                    string = string + "<br><h3>" + UnitDetails.getBundle("UnitDetails_Plugin_Notification") + "</h3>";
                    string = string + "<font color=\"red\">";
                    string = string + unit.annotate(unit.getNotification());
                    string = string + "</font><br>";
                }
                if (unit.getDescription() != null && unit.getDescription().length() > 0) {
                    string = string + "<br><h3>" + UnitDetails.getBundle("UnitDetails_Plugin_Description") + "</h3>";
                    string = string + unit.annotate(unit.getDescription());
                }
            }
            catch (CharConversionException charConversionException) {
                this.err.log(Level.INFO, null, charConversionException);
                return;
            }
            this.getDetails().setText(string);
            object = this.getDetails().getDocument();
            int n = -1;
            try {
                n = unit.findCaretPosition(object.getText(0, object.getLength()));
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            this.getDetails().setCaretPosition(n > 0 ? n : 0);
        }
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage(UnitDetails.class, (String)string);
    }
}

