/*
 * Decompiled with CFR 0.152.
 */
package groovy.swing;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.model.DefaultTableModel;
import groovy.model.ValueHolder;
import groovy.model.ValueModel;
import groovy.swing.impl.ComponentFacade;
import groovy.swing.impl.ContainerFacade;
import groovy.swing.impl.DefaultAction;
import groovy.swing.impl.Factory;
import groovy.swing.impl.Startable;
import groovy.swing.impl.TableLayout;
import groovy.swing.impl.TableLayoutCell;
import groovy.swing.impl.TableLayoutRow;
import groovy.util.BuilderSupport;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.RootPaneContainer;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.codehaus.groovy.runtime.InvokerHelper;

public class SwingBuilder
extends BuilderSupport {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private Map factories = new HashMap();
    private Object constraints;
    private Map passThroughNodes = new HashMap();
    private Map widgets = new HashMap();
    private LinkedList containingWindows = new LinkedList();
    static /* synthetic */ Class class$java$lang$Object;

    public SwingBuilder() {
        this.registerWidgets();
    }

    public Object getProperty(String name) {
        Object widget = this.widgets.get(name);
        if (widget == null) {
            return super.getProperty(name);
        }
        return widget;
    }

    protected void setParent(Object parent, Object child) {
        if (child instanceof Action) {
            Action action = (Action)child;
            try {
                InvokerHelper.setProperty(parent, "action", action);
            }
            catch (RuntimeException re) {
                // empty catch block
            }
            Object keyStroke = action.getValue("KeyStroke");
            if (parent instanceof JComponent) {
                JComponent component = (JComponent)parent;
                KeyStroke stroke = null;
                if (keyStroke instanceof String) {
                    stroke = KeyStroke.getKeyStroke((String)keyStroke);
                } else if (keyStroke instanceof KeyStroke) {
                    stroke = (KeyStroke)keyStroke;
                }
                if (stroke != null) {
                    String key = action.toString();
                    component.getInputMap().put(stroke, key);
                    component.getActionMap().put(key, action);
                }
            }
        } else if (child instanceof LayoutManager) {
            if (parent instanceof RootPaneContainer) {
                RootPaneContainer rpc = (RootPaneContainer)parent;
                parent = rpc.getContentPane();
            }
            InvokerHelper.setProperty(parent, "layout", child);
        } else if (child instanceof JToolTip && parent instanceof JComponent) {
            ((JToolTip)child).setComponent((JComponent)parent);
        } else if (parent instanceof JTable && child instanceof TableColumn) {
            JTable table = (JTable)parent;
            TableColumn column = (TableColumn)child;
            table.addColumn(column);
        } else if (parent instanceof JTabbedPane && child instanceof Component) {
            JTabbedPane tabbedPane = (JTabbedPane)parent;
            tabbedPane.add((Component)child);
        } else if (!(child instanceof Window)) {
            Object facade;
            Component component = null;
            if (child instanceof Component) {
                component = (Component)child;
            } else if (child instanceof ComponentFacade) {
                facade = (ComponentFacade)child;
                component = facade.getComponent();
            }
            if (component != null) {
                if (parent instanceof JFrame && component instanceof JMenuBar) {
                    JFrame frame = (JFrame)parent;
                    frame.setJMenuBar((JMenuBar)component);
                } else if (parent instanceof RootPaneContainer) {
                    RootPaneContainer rpc = (RootPaneContainer)parent;
                    if (this.constraints != null) {
                        rpc.getContentPane().add(component, this.constraints);
                    } else {
                        rpc.getContentPane().add(component);
                    }
                } else if (parent instanceof JScrollPane) {
                    JScrollPane scrollPane = (JScrollPane)parent;
                    if (child instanceof JViewport) {
                        scrollPane.setViewport((JViewport)component);
                    } else {
                        scrollPane.setViewportView(component);
                    }
                } else if (parent instanceof JSplitPane) {
                    JSplitPane splitPane = (JSplitPane)parent;
                    if (splitPane.getOrientation() == 1) {
                        if (splitPane.getTopComponent() == null) {
                            splitPane.setTopComponent(component);
                        } else {
                            splitPane.setBottomComponent(component);
                        }
                    } else if (splitPane.getLeftComponent() == null) {
                        splitPane.setLeftComponent(component);
                    } else {
                        splitPane.setRightComponent(component);
                    }
                } else if (parent instanceof JMenuBar && component instanceof JMenu) {
                    JMenuBar menuBar = (JMenuBar)parent;
                    menuBar.add((JMenu)component);
                } else if (parent instanceof Container) {
                    Container container = (Container)parent;
                    if (this.constraints != null) {
                        container.add(component, this.constraints);
                    } else {
                        container.add(component);
                    }
                } else if (parent instanceof ContainerFacade) {
                    facade = (ContainerFacade)parent;
                    facade.addComponent(component);
                }
            }
        }
    }

    protected void nodeCompleted(Object parent, Object node) {
        if (node instanceof TableModel && parent instanceof JTable) {
            JTable table = (JTable)parent;
            TableModel model = (TableModel)node;
            table.setModel(model);
        }
        if (node instanceof Startable) {
            Startable startable = (Startable)node;
            startable.start();
        }
        if (node instanceof Window && !this.containingWindows.isEmpty() && this.containingWindows.getLast() == node) {
            this.containingWindows.removeLast();
        }
    }

    protected Object createNode(Object name) {
        return this.createNode(name, Collections.EMPTY_MAP);
    }

    protected Object createNode(Object name, Object value) {
        if (this.passThroughNodes.containsKey(name) && value != null && ((Class)this.passThroughNodes.get(name)).isAssignableFrom(value.getClass())) {
            if (value instanceof Window) {
                this.containingWindows.add(value);
            }
            return value;
        }
        if (value instanceof String) {
            Object widget = this.createNode(name);
            if (widget != null) {
                InvokerHelper.invokeMethod(widget, "setText", value);
            }
            return widget;
        }
        throw new MissingMethodException((String)name, this.getClass(), new Object[]{value}, false);
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        if (this.passThroughNodes.containsKey(name) && value != null && ((Class)this.passThroughNodes.get(name)).isAssignableFrom(value.getClass())) {
            if (value instanceof Window) {
                this.containingWindows.add(value);
            }
            this.handleWidgetAttributes(value, attributes);
            return value;
        }
        Object widget = this.createNode(name, attributes);
        if (widget != null) {
            InvokerHelper.invokeMethod(widget, "setText", value.toString());
        }
        return widget;
    }

    /*
     * Unable to fully structure code
     */
    protected Object createNode(Object name, Map attributes) {
        widgetName = (String)attributes.remove("id");
        this.constraints = attributes.remove("constraints");
        widget = null;
        if (this.passThroughNodes.containsKey(name)) {
            widget = attributes.get(name);
            if (widget != null && ((Class)this.passThroughNodes.get(name)).isAssignableFrom(widget.getClass())) {
                if (widget instanceof Window) {
                    this.containingWindows.add(widget);
                }
                attributes.remove(name);
            } else {
                widget = null;
            }
        }
        if (widget == null) {
            factory = (Factory)this.factories.get(name);
            if (factory != null) {
                try {
                    widget = factory.newInstance(attributes);
                    if (widgetName != null) {
                        this.widgets.put(widgetName, widget);
                    }
                    if (widget == null) {
                        this.log.log(Level.WARNING, "Factory for name: " + name + " returned null");
                    }
                    if (!this.log.isLoggable(Level.FINE)) ** GOTO lbl31
                    this.log.fine("For name: " + name + " created widget: " + widget);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create component for" + name + " reason: " + e, e);
                }
            } else {
                this.log.log(Level.WARNING, "Could not find match for name: " + name);
            }
        }
lbl31:
        // 6 sources

        this.handleWidgetAttributes(widget, attributes);
        return widget;
    }

    protected void handleWidgetAttributes(Object widget, Map attributes) {
        block13: {
            if (widget == null) break block13;
            if (widget instanceof Action) {
                Action action = (Action)widget;
                Closure closure = (Closure)attributes.remove("closure");
                if (closure != null && action instanceof DefaultAction) {
                    DefaultAction defaultAction = (DefaultAction)action;
                    defaultAction.setClosure(closure);
                }
                Object accel = attributes.remove("accelerator");
                KeyStroke stroke = null;
                if (accel instanceof KeyStroke) {
                    stroke = (KeyStroke)accel;
                } else if (accel != null) {
                    stroke = KeyStroke.getKeyStroke(accel.toString());
                }
                action.putValue("AcceleratorKey", stroke);
                Object mnemonic = attributes.remove("mnemonic");
                if (mnemonic != null && !(mnemonic instanceof Number)) {
                    mnemonic = new Integer(mnemonic.toString().charAt(0));
                }
                action.putValue("MnemonicKey", mnemonic);
                Iterator iter = attributes.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String actionName = (String)entry.getKey();
                    actionName = this.capitalize(actionName);
                    Object value = entry.getValue();
                    action.putValue(actionName, value);
                }
            } else {
                Object mnemonic;
                Object o;
                if (attributes.containsKey("buttonGroup") && (o = attributes.get("buttonGroup")) instanceof ButtonGroup && widget instanceof AbstractButton) {
                    ((AbstractButton)widget).getModel().setGroup((ButtonGroup)o);
                    attributes.remove("buttonGroup");
                }
                if ((mnemonic = attributes.remove("mnemonic")) != null && mnemonic instanceof Number) {
                    InvokerHelper.setProperty(widget, "mnemonic", new Character((char)((Number)mnemonic).intValue()));
                } else if (mnemonic != null) {
                    InvokerHelper.setProperty(widget, "mnemonic", new Character(mnemonic.toString().charAt(0)));
                }
                Iterator iter = attributes.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String property = entry.getKey().toString();
                    Object value = entry.getValue();
                    InvokerHelper.setProperty(widget, property, value);
                }
            }
        }
    }

    protected String capitalize(String text) {
        char ch = text.charAt(0);
        if (Character.isUpperCase(ch)) {
            return text;
        }
        StringBuffer buffer = new StringBuffer(text.length());
        buffer.append(Character.toUpperCase(ch));
        buffer.append(text.substring(1));
        return buffer.toString();
    }

    protected void registerWidgets() {
        this.registerBeanFactory("action", DefaultAction.class);
        this.passThroughNodes.put("action", Action.class);
        this.registerBeanFactory("buttonGroup", ButtonGroup.class);
        this.registerFactory("map", new Factory(){

            public Object newInstance(Map properties) throws InstantiationException, InstantiationException, IllegalAccessException {
                return properties;
            }
        });
        this.passThroughNodes.put("widget", Component.class);
        this.registerFactory("dialog", new Factory(){

            public Object newInstance(Map properties) throws InstantiationException, InstantiationException, IllegalAccessException {
                return SwingBuilder.this.createDialog(properties);
            }
        });
        this.registerFactory("frame", new Factory(){

            public Object newInstance(Map properties) throws InstantiationException, InstantiationException, IllegalAccessException {
                return SwingBuilder.this.createFrame(properties);
            }
        });
        this.registerBeanFactory("fileChooser", JFileChooser.class);
        this.registerFactory("frame", new Factory(){

            public Object newInstance(Map properties) throws InstantiationException, InstantiationException, IllegalAccessException {
                return SwingBuilder.this.createFrame(properties);
            }
        });
        this.registerBeanFactory("optionPane", JOptionPane.class);
        this.registerFactory("window", new Factory(){

            public Object newInstance(Map properties) throws InstantiationException, InstantiationException, IllegalAccessException {
                return SwingBuilder.this.createWindow(properties);
            }
        });
        this.registerBeanFactory("button", JButton.class);
        this.registerBeanFactory("checkBox", JCheckBox.class);
        this.registerBeanFactory("checkBoxMenuItem", JCheckBoxMenuItem.class);
        this.registerBeanFactory("colorChooser", JColorChooser.class);
        this.registerFactory("comboBox", new Factory(){

            public Object newInstance(Map properties) throws InstantiationException, InstantiationException, IllegalAccessException {
                return SwingBuilder.this.createComboBox(properties);
            }
        });
        this.registerBeanFactory("desktopPane", JDesktopPane.class);
        this.registerBeanFactory("editorPane", JEditorPane.class);
        this.registerFactory("formattedTextField", new Factory(){

            public Object newInstance(Map properties) throws InstantiationException, InstantiationException, IllegalAccessException {
                return SwingBuilder.this.createFormattedTextField(properties);
            }
        });
        this.registerBeanFactory("internalFrame", JInternalFrame.class);
        this.registerBeanFactory("label", JLabel.class);
        this.registerBeanFactory("layeredPane", JLayeredPane.class);
        this.registerBeanFactory("list", JList.class);
        this.registerBeanFactory("menu", JMenu.class);
        this.registerBeanFactory("menuBar", JMenuBar.class);
        this.registerBeanFactory("menuItem", JMenuItem.class);
        this.registerBeanFactory("panel", JPanel.class);
        this.registerBeanFactory("passwordField", JPasswordField.class);
        this.registerBeanFactory("popupMenu", JPopupMenu.class);
        this.registerBeanFactory("progressBar", JProgressBar.class);
        this.registerBeanFactory("radioButton", JRadioButton.class);
        this.registerBeanFactory("radioButtonMenuItem", JRadioButtonMenuItem.class);
        this.registerBeanFactory("scrollBar", JScrollBar.class);
        this.registerBeanFactory("scrollPane", JScrollPane.class);
        this.registerBeanFactory("separator", JSeparator.class);
        this.registerBeanFactory("slider", JSlider.class);
        this.registerBeanFactory("spinner", JSpinner.class);
        this.registerFactory("splitPane", new Factory(){

            public Object newInstance(Map properties) {
                JSplitPane answer = new JSplitPane();
                answer.setLeftComponent(null);
                answer.setRightComponent(null);
                answer.setTopComponent(null);
                answer.setBottomComponent(null);
                return answer;
            }
        });
        this.registerBeanFactory("tabbedPane", JTabbedPane.class);
        this.registerBeanFactory("table", JTable.class);
        this.registerBeanFactory("textArea", JTextArea.class);
        this.registerBeanFactory("textPane", JTextPane.class);
        this.registerBeanFactory("textField", JTextField.class);
        this.registerBeanFactory("toggleButton", JToggleButton.class);
        this.registerBeanFactory("toolBar", JToolBar.class);
        this.registerBeanFactory("tree", JTree.class);
        this.registerBeanFactory("viewport", JViewport.class);
        this.registerBeanFactory("boundedRangeModel", DefaultBoundedRangeModel.class);
        this.registerBeanFactory("spinnerDateModel", SpinnerDateModel.class);
        this.registerBeanFactory("spinnerListModel", SpinnerListModel.class);
        this.registerBeanFactory("spinnerNumberModel", SpinnerNumberModel.class);
        this.registerFactory("tableModel", new Factory(){

            public Object newInstance(Map properties) {
                ValueModel model = (ValueModel)properties.remove("model");
                if (model == null) {
                    Object list = properties.remove("list");
                    if (list == null) {
                        list = new ArrayList();
                    }
                    model = new ValueHolder(list);
                }
                return new DefaultTableModel(model);
            }
        });
        this.passThroughNodes.put("tableModel", TableModel.class);
        this.registerFactory("propertyColumn", new Factory(){

            public Object newInstance(Map properties) {
                Object current = SwingBuilder.this.getCurrent();
                if (current instanceof DefaultTableModel) {
                    String property;
                    DefaultTableModel model = (DefaultTableModel)current;
                    Object header = properties.remove("header");
                    if (header == null) {
                        header = "";
                    }
                    if ((property = (String)properties.remove("propertyName")) == null) {
                        throw new IllegalArgumentException("Must specify a property for a propertyColumn");
                    }
                    Class type = (Class)properties.remove("type");
                    if (type == null) {
                        type = class$java$lang$Object == null ? (class$java$lang$Object = SwingBuilder.class$("java.lang.Object")) : class$java$lang$Object;
                    }
                    return model.addPropertyColumn(header, property, type);
                }
                throw new RuntimeException("propertyColumn must be a child of a tableModel");
            }
        });
        this.registerFactory("closureColumn", new Factory(){

            public Object newInstance(Map properties) {
                Object current = SwingBuilder.this.getCurrent();
                if (current instanceof DefaultTableModel) {
                    Closure readClosure;
                    DefaultTableModel model = (DefaultTableModel)current;
                    Object header = properties.remove("header");
                    if (header == null) {
                        header = "";
                    }
                    if ((readClosure = (Closure)properties.remove("read")) == null) {
                        throw new IllegalArgumentException("Must specify 'read' Closure property for a closureColumn");
                    }
                    Closure writeClosure = (Closure)properties.remove("write");
                    Class type = (Class)properties.remove("type");
                    if (type == null) {
                        type = class$java$lang$Object == null ? (class$java$lang$Object = SwingBuilder.class$("java.lang.Object")) : class$java$lang$Object;
                    }
                    return model.addClosureColumn(header, readClosure, writeClosure, type);
                }
                throw new RuntimeException("propertyColumn must be a child of a tableModel");
            }
        });
        this.registerBeanFactory("borderLayout", BorderLayout.class);
        this.registerBeanFactory("cardLayout", CardLayout.class);
        this.registerBeanFactory("flowLayout", FlowLayout.class);
        this.registerBeanFactory("gridBagLayout", GridBagLayout.class);
        this.registerBeanFactory("gridLayout", GridLayout.class);
        this.registerBeanFactory("overlayLayout", OverlayLayout.class);
        this.registerBeanFactory("springLayout", SpringLayout.class);
        this.registerBeanFactory("gridBagConstraints", GridBagConstraints.class);
        this.registerBeanFactory("gbc", GridBagConstraints.class);
        this.registerFactory("boxLayout", new Factory(){

            public Object newInstance(Map properties) throws InstantiationException, InstantiationException, IllegalAccessException {
                return SwingBuilder.this.createBoxLayout(properties);
            }
        });
        this.registerFactory("hbox", new Factory(){

            public Object newInstance(Map properties) {
                return Box.createHorizontalBox();
            }
        });
        this.registerFactory("hglue", new Factory(){

            public Object newInstance(Map properties) {
                return Box.createHorizontalGlue();
            }
        });
        this.registerFactory("hstrut", new Factory(){

            public Object newInstance(Map properties) {
                try {
                    Object num = properties.remove("width");
                    if (num instanceof Number) {
                        return Box.createHorizontalStrut(((Number)num).intValue());
                    }
                    return Box.createHorizontalStrut(6);
                }
                catch (RuntimeException re) {
                    re.printStackTrace(System.out);
                    throw re;
                }
            }
        });
        this.registerFactory("vbox", new Factory(){

            public Object newInstance(Map properties) {
                return Box.createVerticalBox();
            }
        });
        this.registerFactory("vglue", new Factory(){

            public Object newInstance(Map properties) {
                return Box.createVerticalGlue();
            }
        });
        this.registerFactory("vstrut", new Factory(){

            public Object newInstance(Map properties) {
                Object num = properties.remove("height");
                if (num instanceof Number) {
                    return Box.createVerticalStrut(((Number)num).intValue());
                }
                return Box.createVerticalStrut(6);
            }
        });
        this.registerFactory("glue", new Factory(){

            public Object newInstance(Map properties) {
                return Box.createGlue();
            }
        });
        this.registerFactory("rigidArea", new Factory(){

            public Object newInstance(Map properties) {
                Dimension dim;
                Object o = properties.remove("size");
                if (o instanceof Dimension) {
                    dim = (Dimension)o;
                } else {
                    o = properties.remove("width");
                    int w = o instanceof Number ? ((Number)o).intValue() : 6;
                    o = properties.remove("height");
                    int h = o instanceof Number ? ((Number)o).intValue() : 6;
                    dim = new Dimension(w, h);
                }
                return Box.createRigidArea(dim);
            }
        });
        this.registerBeanFactory("tableLayout", TableLayout.class);
        this.registerFactory("tr", new Factory(){

            public Object newInstance(Map properties) {
                Object parent = SwingBuilder.this.getCurrent();
                if (parent instanceof TableLayout) {
                    return new TableLayoutRow((TableLayout)parent);
                }
                throw new RuntimeException("'tr' must be within a 'tableLayout'");
            }
        });
        this.registerFactory("td", new Factory(){

            public Object newInstance(Map properties) {
                Object parent = SwingBuilder.this.getCurrent();
                if (parent instanceof TableLayoutRow) {
                    return new TableLayoutCell((TableLayoutRow)parent);
                }
                throw new RuntimeException("'td' must be within a 'tr'");
            }
        });
    }

    protected Object createBoxLayout(Map properties) {
        Object parent = this.getCurrent();
        if (parent instanceof Container) {
            Container target;
            Object axisObject = properties.remove("axis");
            int axis = 0;
            if (axisObject != null) {
                Integer i = (Integer)axisObject;
                axis = i;
            }
            if ((target = (Container)parent) instanceof RootPaneContainer) {
                target = ((RootPaneContainer)((Object)target)).getContentPane();
            }
            BoxLayout answer = new BoxLayout(target, axis);
            InvokerHelper.setProperty(parent, "layout", answer);
            return answer;
        }
        throw new RuntimeException("Must be nested inside a Container");
    }

    protected Object createDialog(Map properties) {
        Object owner = properties.remove("owner");
        if (owner == null && !this.containingWindows.isEmpty()) {
            owner = this.containingWindows.getLast();
        }
        JDialog dialog = owner instanceof Frame ? new JDialog((Frame)owner) : (owner instanceof Dialog ? new JDialog((Dialog)owner) : new JDialog());
        this.containingWindows.add(dialog);
        return dialog;
    }

    protected Object createFormattedTextField(Map properties) {
        JFormattedTextField ftf = properties.containsKey("format") ? new JFormattedTextField((Format)properties.remove("format")) : (properties.containsKey("value") ? new JFormattedTextField(properties.remove("value")) : new JFormattedTextField());
        return ftf;
    }

    protected Object createFrame(Map properties) {
        JFrame frame = new JFrame();
        this.containingWindows.add(frame);
        return frame;
    }

    protected Object createWindow(Map properties) {
        Object owner = properties.remove("owner");
        if (owner == null && !this.containingWindows.isEmpty()) {
            owner = this.containingWindows.getLast();
        }
        JWindow window = owner instanceof Frame ? new JWindow((Frame)owner) : (owner instanceof Window ? new JWindow((Window)owner) : new JWindow());
        this.containingWindows.add(window);
        return window;
    }

    protected Object createComboBox(Map properties) {
        Object items = properties.remove("items");
        if (items instanceof Vector) {
            return new JComboBox((Vector)items);
        }
        if (items instanceof List) {
            List list = (List)items;
            return new JComboBox<Object>(list.toArray());
        }
        if (items instanceof Object[]) {
            return new JComboBox<Object>((Object[])items);
        }
        return new JComboBox();
    }

    protected void registerBeanFactory(String name, final Class beanClass) {
        this.registerFactory(name, new Factory(){

            public Object newInstance(Map properties) throws InstantiationException, IllegalAccessException {
                return beanClass.newInstance();
            }
        });
    }

    protected void registerFactory(String name, Factory factory) {
        this.factories.put(name, factory);
    }
}

