/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools.android;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import processing.app.Base;
import processing.app.exec.ProcessHelper;
import processing.app.exec.ProcessResult;
import processing.app.tools.android.AndroidSDK;

public class AVD {
    static final String DEFAULT_SKIN = "WVGA800";
    protected String name;
    protected String target;
    public static final AVD defaultAVD = new AVD("Processing-Android-7", "Google Inc.:Google APIs:7");
    private static final Pattern AVD_ROW = Pattern.compile("\\s+Name:\\s+(\\S+)");
    private static final String AVD_CREATE_ERROR = "An error occurred while running \u201candroid create avd\u201d\nto set up the default Android emulator. Make sure that the\nAndroid SDK is installed properly, and that the Android\nand Google APIs are installed for level 7.";

    public static boolean ensureEclairAVD(AndroidSDK androidSDK) {
        try {
            if (defaultAVD.exists(androidSDK)) {
                System.out.println("the avd exists");
                return true;
            }
            if (defaultAVD.create(androidSDK)) {
                System.out.println("the avd was created");
                return true;
            }
            Base.showWarning("Android Error", AVD_CREATE_ERROR, null);
        }
        catch (Exception exception) {
            Base.showWarning("Android Error", AVD_CREATE_ERROR, exception);
        }
        return false;
    }

    public AVD(String string, String string2) {
        this.name = string;
        this.target = string2;
    }

    protected boolean exists(AndroidSDK androidSDK) throws IOException {
        try {
            ProcessResult processResult = new ProcessHelper(androidSDK.getAndroidToolPath(), "list", "avds").execute();
            if (processResult.succeeded()) {
                for (String string : processResult) {
                    Matcher matcher = AVD_ROW.matcher(string);
                    if (!matcher.matches() || !matcher.group(1).equals(this.name)) continue;
                    return true;
                }
            } else {
                System.err.println("Unhappy inside exists()");
                System.err.println(processResult);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    protected boolean create(AndroidSDK androidSDK) throws IOException {
        String[] stringArray = new String[]{androidSDK.getAndroidToolPath(), "create", "avd", "-n", this.name, "-t", this.target, "-c", "64M", "-s", DEFAULT_SKIN};
        ProcessHelper processHelper = new ProcessHelper(stringArray);
        try {
            ProcessResult processResult = processHelper.execute();
            if (processResult.succeeded()) {
                return true;
            }
            System.err.println(processResult);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }
}

