/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.rpt;

import java.util.ArrayList;
import java.util.List;
import org.jfree.report.expressions.Expression;
import org.jfree.report.expressions.FormulaExpression;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.libreoffice.report.pentaho.model.OfficeGroup;
import org.libreoffice.report.pentaho.model.OfficeGroupInstanceSection;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.DetailRootTableReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.FunctionReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.GroupSectionReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.ReportReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.RootTableReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GroupReadHandler
extends ElementReadHandler {
    private GroupSectionReadHandler groupHeader;
    private GroupSectionReadHandler groupFooter;
    private GroupReadHandler childGroup;
    private RootTableReadHandler detailSection;
    private final OfficeGroup group;
    private final OfficeGroupInstanceSection groupInstanceSection;
    private final List<FunctionReadHandler> functionHandlers;
    private final ReportReadHandler rh;

    public GroupReadHandler(ReportReadHandler reportReadHandler) {
        this.rh = reportReadHandler;
        this.group = new OfficeGroup();
        this.groupInstanceSection = new OfficeGroupInstanceSection();
        this.groupInstanceSection.setNamespace("http://jfreereport.sourceforge.net/namespaces/engine");
        this.groupInstanceSection.setType("group-instance");
        this.group.addNode(this.groupInstanceSection);
        this.functionHandlers = new ArrayList<FunctionReadHandler>();
    }

    @Override
    protected void startParsing(Attributes attributes) throws SAXException {
        Object object;
        super.startParsing(attributes);
        String string = attributes.getValue("http://openoffice.org/2005/report", "group-expression");
        if (string != null && !"".equals(string)) {
            object = new FormulaExpression();
            ((FormulaExpression)object).setFormula(string);
            this.groupInstanceSection.setGroupingExpression((Expression)object);
        }
        if ((object = attributes.getValue("http://openoffice.org/2005/report", "sort-expression")) != null && !"".equals(object)) {
            this.groupInstanceSection.setSortingExpression((String)object);
        }
    }

    protected XmlReadHandler getHandlerForChild(String string, String string2, Attributes attributes) throws SAXException {
        if (!"http://openoffice.org/2005/report".equals(string)) {
            return null;
        }
        if ("function".equals(string2)) {
            FunctionReadHandler functionReadHandler = new FunctionReadHandler();
            this.functionHandlers.add(functionReadHandler);
            return functionReadHandler;
        }
        if ("group-header".equals(string2)) {
            this.groupHeader = new GroupSectionReadHandler();
            return this.groupHeader;
        }
        if ("group".equals(string2)) {
            this.childGroup = new GroupReadHandler(this.rh);
            return this.childGroup;
        }
        if ("detail".equals(string2)) {
            this.detailSection = new DetailRootTableReadHandler();
            this.rh.setDetail(this.detailSection);
            return this.detailSection;
        }
        if ("group-footer".equals(string2)) {
            ((Element)((Section)this.rh.getDetail().getElement()).getNode(0)).setAttribute("http://jfreereport.sourceforge.net/namespaces/engine", "has-group-footer", "true");
            this.groupFooter = new GroupSectionReadHandler();
            return this.groupFooter;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.functionHandlers.size(); ++i) {
            FunctionReadHandler functionReadHandler = this.functionHandlers.get(i);
            this.groupInstanceSection.addExpression(functionReadHandler.getExpression());
        }
        if (this.groupHeader != null) {
            this.groupInstanceSection.addNode(this.groupHeader.getElement());
        }
        Section section = new Section();
        section.setNamespace("http://jfreereport.sourceforge.net/namespaces/engine");
        section.setType("group-body");
        this.groupInstanceSection.addNode(section);
        if (this.detailSection != null) {
            section.addNode(this.detailSection.getElement());
        } else if (this.childGroup != null) {
            section.addNode(this.childGroup.getElement());
        }
        if (this.groupFooter != null) {
            this.groupInstanceSection.addNode(this.groupFooter.getElement());
        }
    }

    @Override
    public Element getElement() {
        return this.group;
    }
}

