/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.transport.dead.DeadLetterTransport;
import org.codehaus.xfire.transport.http.HttpTransport;
import org.codehaus.xfire.transport.http.SoapHttpTransport;
import org.codehaus.xfire.transport.local.LocalTransport;

public class DefaultTransportManager
implements TransportManager {
    private static final Log log = LogFactory.getLog((Class)DefaultTransportManager.class);
    private Set transports = new LinkedHashSet();
    private Map binding2Transport = new HashMap();

    public DefaultTransportManager() {
    }

    public DefaultTransportManager(Set transports) {
        this.transports.addAll(transports);
    }

    public void initialize() {
        this.register(new LocalTransport());
        this.register(new DeadLetterTransport());
        this.register(new SoapHttpTransport());
        this.register(new HttpTransport());
    }

    public void dispose() {
        Iterator itr = this.transports.iterator();
        while (itr.hasNext()) {
            Transport t = (Transport)itr.next();
            t.dispose();
            itr.remove();
        }
    }

    public void register(Transport transport) {
        this.transports.add(transport);
        String[] bindingIds = transport.getSupportedBindings();
        for (int i = 0; i < bindingIds.length; ++i) {
            this.binding2Transport.put(bindingIds[i], transport);
        }
        log.debug((Object)("Registered transport " + transport));
    }

    public void unregister(Transport transport) {
        this.transports.remove(transport);
        String[] bindingIds = transport.getSupportedBindings();
        for (int i = 0; i < bindingIds.length; ++i) {
            if (this.binding2Transport.get(bindingIds[i]) != transport) continue;
            this.binding2Transport.remove(bindingIds[i]);
        }
    }

    public Collection getTransports() {
        return this.transports;
    }

    public Transport getTransportForUri(String uri) {
        Iterator itr = this.transports.iterator();
        while (itr.hasNext()) {
            Transport t = (Transport)itr.next();
            if (!t.isUriSupported(uri)) continue;
            return t;
        }
        return null;
    }

    public Collection getTransportsForUri(String uri) {
        HashSet<Transport> uritrans = new HashSet<Transport>();
        Iterator itr = this.transports.iterator();
        while (itr.hasNext()) {
            Transport t = (Transport)itr.next();
            if (!t.isUriSupported(uri)) continue;
            uritrans.add(t);
        }
        return uritrans;
    }

    public Transport getTransport(String id) {
        return (Transport)this.binding2Transport.get(id);
    }
}

