/*
 * This declarations of the PIC18LF26K22 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:55 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC18LF26K22_H__
#define __PIC18LF26K22_H__

//==============================================================================

//==============================================================================
//
//	Register Definitions
//
//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x0F38) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned ANSA3                : 1;
  unsigned                      : 1;
  unsigned ANSA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x0F38) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA3                  0x08
#define _ANSA5                  0x20

//==============================================================================


//==============================================================================
//        ANSELB Bits

extern __at(0x0F39) __sfr ANSELB;

typedef union
  {
  struct
    {
    unsigned ANSB0              : 1;
    unsigned ANSB1              : 1;
    unsigned ANSB2              : 1;
    unsigned ANSB3              : 1;
    unsigned ANSB4              : 1;
    unsigned ANSB5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSB               : 6;
    unsigned                    : 2;
    };
  } __ANSELBbits_t;

extern __at(0x0F39) volatile __ANSELBbits_t ANSELBbits;

#define _ANSB0                  0x01
#define _ANSB1                  0x02
#define _ANSB2                  0x04
#define _ANSB3                  0x08
#define _ANSB4                  0x10
#define _ANSB5                  0x20

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x0F3A) __sfr ANSELC;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANSC2                : 1;
  unsigned ANSC3                : 1;
  unsigned ANSC4                : 1;
  unsigned ANSC5                : 1;
  unsigned ANSC6                : 1;
  unsigned ANSC7                : 1;
  } __ANSELCbits_t;

extern __at(0x0F3A) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC2                  0x04
#define _ANSC3                  0x08
#define _ANSC4                  0x10
#define _ANSC5                  0x20
#define _ANSC6                  0x40
#define _ANSC7                  0x80

//==============================================================================


//==============================================================================
//        PMD2 Bits

extern __at(0x0F3D) __sfr PMD2;

typedef struct
  {
  unsigned ADCMD                : 1;
  unsigned CMP1MD               : 1;
  unsigned CMP2MD               : 1;
  unsigned CTMUMD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PMD2bits_t;

extern __at(0x0F3D) volatile __PMD2bits_t PMD2bits;

#define _ADCMD                  0x01
#define _CMP1MD                 0x02
#define _CMP2MD                 0x04
#define _CTMUMD                 0x08

//==============================================================================


//==============================================================================
//        PMD1 Bits

extern __at(0x0F3E) __sfr PMD1;

typedef struct
  {
  unsigned CCP1MD               : 1;
  unsigned CCP2MD               : 1;
  unsigned CCP3MD               : 1;
  unsigned CCP4MD               : 1;
  unsigned CCP5MD               : 1;
  unsigned                      : 1;
  unsigned MSSP1MD              : 1;
  unsigned MSSP2MD              : 1;
  } __PMD1bits_t;

extern __at(0x0F3E) volatile __PMD1bits_t PMD1bits;

#define _CCP1MD                 0x01
#define _CCP2MD                 0x02
#define _CCP3MD                 0x04
#define _CCP4MD                 0x08
#define _CCP5MD                 0x10
#define _MSSP1MD                0x40
#define _MSSP2MD                0x80

//==============================================================================


//==============================================================================
//        PMD0 Bits

extern __at(0x0F3F) __sfr PMD0;

typedef struct
  {
  unsigned TMR1MD               : 1;
  unsigned TMR2MD               : 1;
  unsigned TMR3MD               : 1;
  unsigned TMR4MD               : 1;
  unsigned TMR5MD               : 1;
  unsigned TMR6MD               : 1;
  unsigned UART1MD              : 1;
  unsigned UART2MD              : 1;
  } __PMD0bits_t;

extern __at(0x0F3F) volatile __PMD0bits_t PMD0bits;

#define _TMR1MD                 0x01
#define _TMR2MD                 0x02
#define _TMR3MD                 0x04
#define _TMR4MD                 0x08
#define _TMR5MD                 0x10
#define _TMR6MD                 0x20
#define _UART1MD                0x40
#define _UART2MD                0x80

//==============================================================================


//==============================================================================
//        DACCON1 Bits

extern __at(0x0F40) __sfr DACCON1;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };
  } __DACCON1bits_t;

extern __at(0x0F40) volatile __DACCON1bits_t DACCON1bits;

#define _DACR0                  0x01
#define _DACR1                  0x02
#define _DACR2                  0x04
#define _DACR3                  0x08
#define _DACR4                  0x10

//==============================================================================


//==============================================================================
//        VREFCON2 Bits

extern __at(0x0F40) __sfr VREFCON2;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };
  } __VREFCON2bits_t;

extern __at(0x0F40) volatile __VREFCON2bits_t VREFCON2bits;

#define _VREFCON2_DACR0         0x01
#define _VREFCON2_DACR1         0x02
#define _VREFCON2_DACR2         0x04
#define _VREFCON2_DACR3         0x08
#define _VREFCON2_DACR4         0x10

//==============================================================================


//==============================================================================
//        DACCON0 Bits

extern __at(0x0F41) __sfr DACCON0;

typedef union
  {
  struct
    {
    unsigned DACNSS             : 1;
    unsigned                    : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned                    : 1;
    unsigned DACOE              : 1;
    unsigned DACLPS             : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };
  } __DACCON0bits_t;

extern __at(0x0F41) volatile __DACCON0bits_t DACCON0bits;

#define _DACNSS                 0x01
#define _DACPSS0                0x04
#define _DACPSS1                0x08
#define _DACOE                  0x20
#define _DACLPS                 0x40
#define _DACEN                  0x80

//==============================================================================


//==============================================================================
//        VREFCON1 Bits

extern __at(0x0F41) __sfr VREFCON1;

typedef union
  {
  struct
    {
    unsigned DACNSS             : 1;
    unsigned                    : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned                    : 1;
    unsigned DACOE              : 1;
    unsigned DACLPS             : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };
  } __VREFCON1bits_t;

extern __at(0x0F41) volatile __VREFCON1bits_t VREFCON1bits;

#define _VREFCON1_DACNSS        0x01
#define _VREFCON1_DACPSS0       0x04
#define _VREFCON1_DACPSS1       0x08
#define _VREFCON1_DACOE         0x20
#define _VREFCON1_DACLPS        0x40
#define _VREFCON1_DACEN         0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0F42) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FVRS0              : 1;
    unsigned FVRS1              : 1;
    unsigned FVRST              : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned FVRS               : 2;
    unsigned                    : 2;
    };
  } __FVRCONbits_t;

extern __at(0x0F42) volatile __FVRCONbits_t FVRCONbits;

#define _FVRS0                  0x10
#define _FVRS1                  0x20
#define _FVRST                  0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        VREFCON0 Bits

extern __at(0x0F42) __sfr VREFCON0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FVRS0              : 1;
    unsigned FVRS1              : 1;
    unsigned FVRST              : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned FVRS               : 2;
    unsigned                    : 2;
    };
  } __VREFCON0bits_t;

extern __at(0x0F42) volatile __VREFCON0bits_t VREFCON0bits;

#define _VREFCON0_FVRS0         0x10
#define _VREFCON0_FVRS1         0x20
#define _VREFCON0_FVRST         0x40
#define _VREFCON0_FVREN         0x80

//==============================================================================


//==============================================================================
//        CTMUICON Bits

extern __at(0x0F43) __sfr CTMUICON;

typedef union
  {
  struct
    {
    unsigned IRNG0              : 1;
    unsigned IRNG1              : 1;
    unsigned ITRIM0             : 1;
    unsigned ITRIM1             : 1;
    unsigned ITRIM2             : 1;
    unsigned ITRIM3             : 1;
    unsigned ITRIM4             : 1;
    unsigned ITRIM5             : 1;
    };

  struct
    {
    unsigned IRNG               : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned ITRIM              : 6;
    };
  } __CTMUICONbits_t;

extern __at(0x0F43) volatile __CTMUICONbits_t CTMUICONbits;

#define _IRNG0                  0x01
#define _IRNG1                  0x02
#define _ITRIM0                 0x04
#define _ITRIM1                 0x08
#define _ITRIM2                 0x10
#define _ITRIM3                 0x20
#define _ITRIM4                 0x40
#define _ITRIM5                 0x80

//==============================================================================


//==============================================================================
//        CTMUICONH Bits

extern __at(0x0F43) __sfr CTMUICONH;

typedef union
  {
  struct
    {
    unsigned IRNG0              : 1;
    unsigned IRNG1              : 1;
    unsigned ITRIM0             : 1;
    unsigned ITRIM1             : 1;
    unsigned ITRIM2             : 1;
    unsigned ITRIM3             : 1;
    unsigned ITRIM4             : 1;
    unsigned ITRIM5             : 1;
    };

  struct
    {
    unsigned IRNG               : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned ITRIM              : 6;
    };
  } __CTMUICONHbits_t;

extern __at(0x0F43) volatile __CTMUICONHbits_t CTMUICONHbits;

#define _CTMUICONH_IRNG0        0x01
#define _CTMUICONH_IRNG1        0x02
#define _CTMUICONH_ITRIM0       0x04
#define _CTMUICONH_ITRIM1       0x08
#define _CTMUICONH_ITRIM2       0x10
#define _CTMUICONH_ITRIM3       0x20
#define _CTMUICONH_ITRIM4       0x40
#define _CTMUICONH_ITRIM5       0x80

//==============================================================================


//==============================================================================
//        CTMUCON1 Bits

extern __at(0x0F44) __sfr CTMUCON1;

typedef union
  {
  struct
    {
    unsigned EDG1STAT           : 1;
    unsigned EDG2STAT           : 1;
    unsigned EDG1SEL0           : 1;
    unsigned EDG1SEL1           : 1;
    unsigned EDG1POL            : 1;
    unsigned EDG2SEL0           : 1;
    unsigned EDG2SEL1           : 1;
    unsigned EDG2POL            : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned EDG1SEL            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned EDG2SEL            : 2;
    unsigned                    : 1;
    };
  } __CTMUCON1bits_t;

extern __at(0x0F44) volatile __CTMUCON1bits_t CTMUCON1bits;

#define _EDG1STAT               0x01
#define _EDG2STAT               0x02
#define _EDG1SEL0               0x04
#define _EDG1SEL1               0x08
#define _EDG1POL                0x10
#define _EDG2SEL0               0x20
#define _EDG2SEL1               0x40
#define _EDG2POL                0x80

//==============================================================================


//==============================================================================
//        CTMUCONL Bits

extern __at(0x0F44) __sfr CTMUCONL;

typedef union
  {
  struct
    {
    unsigned EDG1STAT           : 1;
    unsigned EDG2STAT           : 1;
    unsigned EDG1SEL0           : 1;
    unsigned EDG1SEL1           : 1;
    unsigned EDG1POL            : 1;
    unsigned EDG2SEL0           : 1;
    unsigned EDG2SEL1           : 1;
    unsigned EDG2POL            : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned EDG1SEL            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned EDG2SEL            : 2;
    unsigned                    : 1;
    };
  } __CTMUCONLbits_t;

extern __at(0x0F44) volatile __CTMUCONLbits_t CTMUCONLbits;

#define _CTMUCONL_EDG1STAT      0x01
#define _CTMUCONL_EDG2STAT      0x02
#define _CTMUCONL_EDG1SEL0      0x04
#define _CTMUCONL_EDG1SEL1      0x08
#define _CTMUCONL_EDG1POL       0x10
#define _CTMUCONL_EDG2SEL0      0x20
#define _CTMUCONL_EDG2SEL1      0x40
#define _CTMUCONL_EDG2POL       0x80

//==============================================================================


//==============================================================================
//        CTMUCON0 Bits

extern __at(0x0F45) __sfr CTMUCON0;

typedef struct
  {
  unsigned CTTRIG               : 1;
  unsigned IDISSEN              : 1;
  unsigned EDGSEQEN             : 1;
  unsigned EDGEN                : 1;
  unsigned TGEN                 : 1;
  unsigned CTMUSIDL             : 1;
  unsigned                      : 1;
  unsigned CTMUEN               : 1;
  } __CTMUCON0bits_t;

extern __at(0x0F45) volatile __CTMUCON0bits_t CTMUCON0bits;

#define _CTTRIG                 0x01
#define _IDISSEN                0x02
#define _EDGSEQEN               0x04
#define _EDGEN                  0x08
#define _TGEN                   0x10
#define _CTMUSIDL               0x20
#define _CTMUEN                 0x80

//==============================================================================


//==============================================================================
//        CTMUCONH Bits

extern __at(0x0F45) __sfr CTMUCONH;

typedef struct
  {
  unsigned CTTRIG               : 1;
  unsigned IDISSEN              : 1;
  unsigned EDGSEQEN             : 1;
  unsigned EDGEN                : 1;
  unsigned TGEN                 : 1;
  unsigned CTMUSIDL             : 1;
  unsigned                      : 1;
  unsigned CTMUEN               : 1;
  } __CTMUCONHbits_t;

extern __at(0x0F45) volatile __CTMUCONHbits_t CTMUCONHbits;

#define _CTMUCONH_CTTRIG        0x01
#define _CTMUCONH_IDISSEN       0x02
#define _CTMUCONH_EDGSEQEN      0x04
#define _CTMUCONH_EDGEN         0x08
#define _CTMUCONH_TGEN          0x10
#define _CTMUCONH_CTMUSIDL      0x20
#define _CTMUCONH_CTMUEN        0x80

//==============================================================================


//==============================================================================
//        SRCON1 Bits

extern __at(0x0F46) __sfr SRCON1;

typedef struct
  {
  unsigned SRRC1E               : 1;
  unsigned SRRC2E               : 1;
  unsigned SRRCKE               : 1;
  unsigned SRRPE                : 1;
  unsigned SRSC1E               : 1;
  unsigned SRSC2E               : 1;
  unsigned SRSCKE               : 1;
  unsigned SRSPE                : 1;
  } __SRCON1bits_t;

extern __at(0x0F46) volatile __SRCON1bits_t SRCON1bits;

#define _SRRC1E                 0x01
#define _SRRC2E                 0x02
#define _SRRCKE                 0x04
#define _SRRPE                  0x08
#define _SRSC1E                 0x10
#define _SRSC2E                 0x20
#define _SRSCKE                 0x40
#define _SRSPE                  0x80

//==============================================================================


//==============================================================================
//        SRCON0 Bits

extern __at(0x0F47) __sfr SRCON0;

typedef union
  {
  struct
    {
    unsigned SRPR               : 1;
    unsigned SRPS               : 1;
    unsigned SRNQEN             : 1;
    unsigned SRQEN              : 1;
    unsigned SRCLK0             : 1;
    unsigned SRCLK1             : 1;
    unsigned SRCLK2             : 1;
    unsigned SRLEN              : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned SRCLK              : 3;
    unsigned                    : 1;
    };
  } __SRCON0bits_t;

extern __at(0x0F47) volatile __SRCON0bits_t SRCON0bits;

#define _SRPR                   0x01
#define _SRPS                   0x02
#define _SRNQEN                 0x04
#define _SRQEN                  0x08
#define _SRCLK0                 0x10
#define _SRCLK1                 0x20
#define _SRCLK2                 0x40
#define _SRLEN                  0x80

//==============================================================================


//==============================================================================
//        CCPTMRS1 Bits

extern __at(0x0F48) __sfr CCPTMRS1;

typedef union
  {
  struct
    {
    unsigned C4TSEL0            : 1;
    unsigned C4TSEL1            : 1;
    unsigned C5TSEL0            : 1;
    unsigned C5TSEL1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C4TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned C5TSEL             : 2;
    unsigned                    : 4;
    };
  } __CCPTMRS1bits_t;

extern __at(0x0F48) volatile __CCPTMRS1bits_t CCPTMRS1bits;

#define _C4TSEL0                0x01
#define _C4TSEL1                0x02
#define _C5TSEL0                0x04
#define _C5TSEL1                0x08

//==============================================================================


//==============================================================================
//        CCPTMRS0 Bits

extern __at(0x0F49) __sfr CCPTMRS0;

typedef union
  {
  struct
    {
    unsigned C1TSEL0            : 1;
    unsigned C1TSEL1            : 1;
    unsigned                    : 1;
    unsigned C2TSEL0            : 1;
    unsigned C2TSEL1            : 1;
    unsigned                    : 1;
    unsigned C3TSEL0            : 1;
    unsigned C3TSEL1            : 1;
    };

  struct
    {
    unsigned C1TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned C2TSEL             : 2;
    unsigned                    : 3;
    };

  struct
    {
    unsigned                    : 6;
    unsigned C3TSEL             : 2;
    };
  } __CCPTMRS0bits_t;

extern __at(0x0F49) volatile __CCPTMRS0bits_t CCPTMRS0bits;

#define _C1TSEL0                0x01
#define _C1TSEL1                0x02
#define _C2TSEL0                0x08
#define _C2TSEL1                0x10
#define _C3TSEL0                0x40
#define _C3TSEL1                0x80

//==============================================================================


//==============================================================================
//        T6CON Bits

extern __at(0x0F4A) __sfr T6CON;

typedef union
  {
  struct
    {
    unsigned T6CKPS0            : 1;
    unsigned T6CKPS1            : 1;
    unsigned TMR6ON             : 1;
    unsigned T6OUTPS0           : 1;
    unsigned T6OUTPS1           : 1;
    unsigned T6OUTPS2           : 1;
    unsigned T6OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T6OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T6CONbits_t;

extern __at(0x0F4A) volatile __T6CONbits_t T6CONbits;

#define _T6CKPS0                0x01
#define _T6CKPS1                0x02
#define _TMR6ON                 0x04
#define _T6OUTPS0               0x08
#define _T6OUTPS1               0x10
#define _T6OUTPS2               0x20
#define _T6OUTPS3               0x40

//==============================================================================

extern __at(0x0F4B) __sfr PR6;
extern __at(0x0F4C) __sfr TMR6;

//==============================================================================
//        T5GCON Bits

extern __at(0x0F4D) __sfr T5GCON;

typedef union
  {
  struct
    {
    unsigned T5GSS0             : 1;
    unsigned T5GSS1             : 1;
    unsigned T5GVAL             : 1;
    unsigned T5GGO_NOT_DONE     : 1;
    unsigned T5GSPM             : 1;
    unsigned T5GTM              : 1;
    unsigned T5GPOL             : 1;
    unsigned TMR5GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T5GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T5G_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T5GSS              : 2;
    unsigned                    : 6;
    };
  } __T5GCONbits_t;

extern __at(0x0F4D) volatile __T5GCONbits_t T5GCONbits;

#define _T5GSS0                 0x01
#define _T5GSS1                 0x02
#define _T5GVAL                 0x04
#define _T5GGO_NOT_DONE         0x08
#define _T5GGO                  0x08
#define _T5G_DONE               0x08
#define _T5GSPM                 0x10
#define _T5GTM                  0x20
#define _T5GPOL                 0x40
#define _TMR5GE                 0x80

//==============================================================================


//==============================================================================
//        T5CON Bits

extern __at(0x0F4E) __sfr T5CON;

typedef union
  {
  struct
    {
    unsigned TMR5ON             : 1;
    unsigned T5RD16             : 1;
    unsigned NOT_T5SYNC         : 1;
    unsigned T5SOSCEN           : 1;
    unsigned T5CKPS0            : 1;
    unsigned T5CKPS1            : 1;
    unsigned TMR5CS0            : 1;
    unsigned TMR5CS1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T5SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T5CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR5CS             : 2;
    };
  } __T5CONbits_t;

extern __at(0x0F4E) volatile __T5CONbits_t T5CONbits;

#define _TMR5ON                 0x01
#define _T5RD16                 0x02
#define _NOT_T5SYNC             0x04
#define _T5SYNC                 0x04
#define _T5SOSCEN               0x08
#define _T5CKPS0                0x10
#define _T5CKPS1                0x20
#define _TMR5CS0                0x40
#define _TMR5CS1                0x80

//==============================================================================

extern __at(0x0F4F) __sfr TMR5;
extern __at(0x0F4F) __sfr TMR5L;
extern __at(0x0F50) __sfr TMR5H;

//==============================================================================
//        T4CON Bits

extern __at(0x0F51) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned TMR4ON             : 1;
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T4OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0F51) volatile __T4CONbits_t T4CONbits;

#define _T4CKPS0                0x01
#define _T4CKPS1                0x02
#define _TMR4ON                 0x04
#define _T4OUTPS0               0x08
#define _T4OUTPS1               0x10
#define _T4OUTPS2               0x20
#define _T4OUTPS3               0x40

//==============================================================================

extern __at(0x0F52) __sfr PR4;
extern __at(0x0F53) __sfr TMR4;

//==============================================================================
//        CCP5CON Bits

extern __at(0x0F54) __sfr CCP5CON;

typedef union
  {
  struct
    {
    unsigned CCP5M0             : 1;
    unsigned CCP5M1             : 1;
    unsigned CCP5M2             : 1;
    unsigned CCP5M3             : 1;
    unsigned DC5B0              : 1;
    unsigned DC5B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP5M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC5B               : 2;
    unsigned                    : 2;
    };
  } __CCP5CONbits_t;

extern __at(0x0F54) volatile __CCP5CONbits_t CCP5CONbits;

#define _CCP5M0                 0x01
#define _CCP5M1                 0x02
#define _CCP5M2                 0x04
#define _CCP5M3                 0x08
#define _DC5B0                  0x10
#define _DC5B1                  0x20

//==============================================================================

extern __at(0x0F55) __sfr CCPR5;
extern __at(0x0F55) __sfr CCPR5L;
extern __at(0x0F56) __sfr CCPR5H;

//==============================================================================
//        CCP4CON Bits

extern __at(0x0F57) __sfr CCP4CON;

typedef union
  {
  struct
    {
    unsigned CCP4M0             : 1;
    unsigned CCP4M1             : 1;
    unsigned CCP4M2             : 1;
    unsigned CCP4M3             : 1;
    unsigned DC4B0              : 1;
    unsigned DC4B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP4M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC4B               : 2;
    unsigned                    : 2;
    };
  } __CCP4CONbits_t;

extern __at(0x0F57) volatile __CCP4CONbits_t CCP4CONbits;

#define _CCP4M0                 0x01
#define _CCP4M1                 0x02
#define _CCP4M2                 0x04
#define _CCP4M3                 0x08
#define _DC4B0                  0x10
#define _DC4B1                  0x20

//==============================================================================

extern __at(0x0F58) __sfr CCPR4;
extern __at(0x0F58) __sfr CCPR4L;
extern __at(0x0F59) __sfr CCPR4H;

//==============================================================================
//        PSTR3CON Bits

extern __at(0x0F5A) __sfr PSTR3CON;

typedef struct
  {
  unsigned STR3A                : 1;
  unsigned STR3B                : 1;
  unsigned STR3C                : 1;
  unsigned STR3D                : 1;
  unsigned STR3SYNC             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSTR3CONbits_t;

extern __at(0x0F5A) volatile __PSTR3CONbits_t PSTR3CONbits;

#define _STR3A                  0x01
#define _STR3B                  0x02
#define _STR3C                  0x04
#define _STR3D                  0x08
#define _STR3SYNC               0x10

//==============================================================================


//==============================================================================
//        CCP3AS Bits

extern __at(0x0F5B) __sfr CCP3AS;

typedef union
  {
  struct
    {
    unsigned P3SSBD0            : 1;
    unsigned P3SSBD1            : 1;
    unsigned P3SSAC0            : 1;
    unsigned P3SSAC1            : 1;
    unsigned CCP3AS0            : 1;
    unsigned CCP3AS1            : 1;
    unsigned CCP3AS2            : 1;
    unsigned CCP3ASE            : 1;
    };

  struct
    {
    unsigned PSS3BD0            : 1;
    unsigned PSS3BD1            : 1;
    unsigned PSS3AC0            : 1;
    unsigned PSS3AC1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PSS3BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned P3SSBD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS3AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned P3SSAC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CCP3AS             : 3;
    unsigned                    : 1;
    };
  } __CCP3ASbits_t;

extern __at(0x0F5B) volatile __CCP3ASbits_t CCP3ASbits;

#define _P3SSBD0                0x01
#define _PSS3BD0                0x01
#define _P3SSBD1                0x02
#define _PSS3BD1                0x02
#define _P3SSAC0                0x04
#define _PSS3AC0                0x04
#define _P3SSAC1                0x08
#define _PSS3AC1                0x08
#define _CCP3AS0                0x10
#define _CCP3AS1                0x20
#define _CCP3AS2                0x40
#define _CCP3ASE                0x80

//==============================================================================


//==============================================================================
//        ECCP3AS Bits

extern __at(0x0F5B) __sfr ECCP3AS;

typedef union
  {
  struct
    {
    unsigned P3SSBD0            : 1;
    unsigned P3SSBD1            : 1;
    unsigned P3SSAC0            : 1;
    unsigned P3SSAC1            : 1;
    unsigned CCP3AS0            : 1;
    unsigned CCP3AS1            : 1;
    unsigned CCP3AS2            : 1;
    unsigned CCP3ASE            : 1;
    };

  struct
    {
    unsigned PSS3BD0            : 1;
    unsigned PSS3BD1            : 1;
    unsigned PSS3AC0            : 1;
    unsigned PSS3AC1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PSS3BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned P3SSBD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned P3SSAC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS3AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CCP3AS             : 3;
    unsigned                    : 1;
    };
  } __ECCP3ASbits_t;

extern __at(0x0F5B) volatile __ECCP3ASbits_t ECCP3ASbits;

#define _ECCP3AS_P3SSBD0        0x01
#define _ECCP3AS_PSS3BD0        0x01
#define _ECCP3AS_P3SSBD1        0x02
#define _ECCP3AS_PSS3BD1        0x02
#define _ECCP3AS_P3SSAC0        0x04
#define _ECCP3AS_PSS3AC0        0x04
#define _ECCP3AS_P3SSAC1        0x08
#define _ECCP3AS_PSS3AC1        0x08
#define _ECCP3AS_CCP3AS0        0x10
#define _ECCP3AS_CCP3AS1        0x20
#define _ECCP3AS_CCP3AS2        0x40
#define _ECCP3AS_CCP3ASE        0x80

//==============================================================================


//==============================================================================
//        PWM3CON Bits

extern __at(0x0F5C) __sfr PWM3CON;

typedef union
  {
  struct
    {
    unsigned P3DC0              : 1;
    unsigned P3DC1              : 1;
    unsigned P3DC2              : 1;
    unsigned P3DC3              : 1;
    unsigned P3DC4              : 1;
    unsigned P3DC5              : 1;
    unsigned P3DC6              : 1;
    unsigned P3RSEN             : 1;
    };

  struct
    {
    unsigned P3DC               : 7;
    unsigned                    : 1;
    };
  } __PWM3CONbits_t;

extern __at(0x0F5C) volatile __PWM3CONbits_t PWM3CONbits;

#define _P3DC0                  0x01
#define _P3DC1                  0x02
#define _P3DC2                  0x04
#define _P3DC3                  0x08
#define _P3DC4                  0x10
#define _P3DC5                  0x20
#define _P3DC6                  0x40
#define _P3RSEN                 0x80

//==============================================================================


//==============================================================================
//        CCP3CON Bits

extern __at(0x0F5D) __sfr CCP3CON;

typedef union
  {
  struct
    {
    unsigned CCP3M0             : 1;
    unsigned CCP3M1             : 1;
    unsigned CCP3M2             : 1;
    unsigned CCP3M3             : 1;
    unsigned DC3B0              : 1;
    unsigned DC3B1              : 1;
    unsigned P3M0               : 1;
    unsigned P3M1               : 1;
    };

  struct
    {
    unsigned CCP3M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC3B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P3M                : 2;
    };
  } __CCP3CONbits_t;

extern __at(0x0F5D) volatile __CCP3CONbits_t CCP3CONbits;

#define _CCP3M0                 0x01
#define _CCP3M1                 0x02
#define _CCP3M2                 0x04
#define _CCP3M3                 0x08
#define _DC3B0                  0x10
#define _DC3B1                  0x20
#define _P3M0                   0x40
#define _P3M1                   0x80

//==============================================================================

extern __at(0x0F5E) __sfr CCPR3;
extern __at(0x0F5E) __sfr CCPR3L;
extern __at(0x0F5F) __sfr CCPR3H;

//==============================================================================
//        SLRCON Bits

extern __at(0x0F60) __sfr SLRCON;

typedef struct
  {
  unsigned SLRA                 : 1;
  unsigned SLRB                 : 1;
  unsigned SLRC                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __SLRCONbits_t;

extern __at(0x0F60) volatile __SLRCONbits_t SLRCONbits;

#define _SLRA                   0x01
#define _SLRB                   0x02
#define _SLRC                   0x04

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x0F61) __sfr WPUB;

typedef struct
  {
  unsigned WPUB0                : 1;
  unsigned WPUB1                : 1;
  unsigned WPUB2                : 1;
  unsigned WPUB3                : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x0F61) volatile __WPUBbits_t WPUBbits;

#define _WPUB0                  0x01
#define _WPUB1                  0x02
#define _WPUB2                  0x04
#define _WPUB3                  0x08
#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        IOCB Bits

extern __at(0x0F62) __sfr IOCB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCB4                : 1;
  unsigned IOCB5                : 1;
  unsigned IOCB6                : 1;
  unsigned IOCB7                : 1;
  } __IOCBbits_t;

extern __at(0x0F62) volatile __IOCBbits_t IOCBbits;

#define _IOCB4                  0x10
#define _IOCB5                  0x20
#define _IOCB6                  0x40
#define _IOCB7                  0x80

//==============================================================================


//==============================================================================
//        PSTR2CON Bits

extern __at(0x0F63) __sfr PSTR2CON;

typedef struct
  {
  unsigned STR2A                : 1;
  unsigned STR2B                : 1;
  unsigned STR2C                : 1;
  unsigned STR2D                : 1;
  unsigned STR2SYNC             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSTR2CONbits_t;

extern __at(0x0F63) volatile __PSTR2CONbits_t PSTR2CONbits;

#define _STR2A                  0x01
#define _STR2B                  0x02
#define _STR2C                  0x04
#define _STR2D                  0x08
#define _STR2SYNC               0x10

//==============================================================================


//==============================================================================
//        CCP2AS Bits

extern __at(0x0F64) __sfr CCP2AS;

typedef union
  {
  struct
    {
    unsigned P2SSBD0            : 1;
    unsigned P2SSBD1            : 1;
    unsigned P2SSAC0            : 1;
    unsigned P2SSAC1            : 1;
    unsigned CCP2AS0            : 1;
    unsigned CCP2AS1            : 1;
    unsigned CCP2AS2            : 1;
    unsigned CCP2ASE            : 1;
    };

  struct
    {
    unsigned PSS2BD0            : 1;
    unsigned PSS2BD1            : 1;
    unsigned PSS2AC0            : 1;
    unsigned PSS2AC1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned P2SSBD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PSS2BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS2AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned P2SSAC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CCP2AS             : 3;
    unsigned                    : 1;
    };
  } __CCP2ASbits_t;

extern __at(0x0F64) volatile __CCP2ASbits_t CCP2ASbits;

#define _P2SSBD0                0x01
#define _PSS2BD0                0x01
#define _P2SSBD1                0x02
#define _PSS2BD1                0x02
#define _P2SSAC0                0x04
#define _PSS2AC0                0x04
#define _P2SSAC1                0x08
#define _PSS2AC1                0x08
#define _CCP2AS0                0x10
#define _CCP2AS1                0x20
#define _CCP2AS2                0x40
#define _CCP2ASE                0x80

//==============================================================================


//==============================================================================
//        ECCP2AS Bits

extern __at(0x0F64) __sfr ECCP2AS;

typedef union
  {
  struct
    {
    unsigned P2SSBD0            : 1;
    unsigned P2SSBD1            : 1;
    unsigned P2SSAC0            : 1;
    unsigned P2SSAC1            : 1;
    unsigned CCP2AS0            : 1;
    unsigned CCP2AS1            : 1;
    unsigned CCP2AS2            : 1;
    unsigned CCP2ASE            : 1;
    };

  struct
    {
    unsigned PSS2BD0            : 1;
    unsigned PSS2BD1            : 1;
    unsigned PSS2AC0            : 1;
    unsigned PSS2AC1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned P2SSBD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PSS2BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned P2SSAC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS2AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CCP2AS             : 3;
    unsigned                    : 1;
    };
  } __ECCP2ASbits_t;

extern __at(0x0F64) volatile __ECCP2ASbits_t ECCP2ASbits;

#define _ECCP2AS_P2SSBD0        0x01
#define _ECCP2AS_PSS2BD0        0x01
#define _ECCP2AS_P2SSBD1        0x02
#define _ECCP2AS_PSS2BD1        0x02
#define _ECCP2AS_P2SSAC0        0x04
#define _ECCP2AS_PSS2AC0        0x04
#define _ECCP2AS_P2SSAC1        0x08
#define _ECCP2AS_PSS2AC1        0x08
#define _ECCP2AS_CCP2AS0        0x10
#define _ECCP2AS_CCP2AS1        0x20
#define _ECCP2AS_CCP2AS2        0x40
#define _ECCP2AS_CCP2ASE        0x80

//==============================================================================


//==============================================================================
//        PWM2CON Bits

extern __at(0x0F65) __sfr PWM2CON;

typedef union
  {
  struct
    {
    unsigned P2DC0              : 1;
    unsigned P2DC1              : 1;
    unsigned P2DC2              : 1;
    unsigned P2DC3              : 1;
    unsigned P2DC4              : 1;
    unsigned P2DC5              : 1;
    unsigned P2DC6              : 1;
    unsigned P2RSEN             : 1;
    };

  struct
    {
    unsigned P2DC               : 7;
    unsigned                    : 1;
    };
  } __PWM2CONbits_t;

extern __at(0x0F65) volatile __PWM2CONbits_t PWM2CONbits;

#define _P2DC0                  0x01
#define _P2DC1                  0x02
#define _P2DC2                  0x04
#define _P2DC3                  0x08
#define _P2DC4                  0x10
#define _P2DC5                  0x20
#define _P2DC6                  0x40
#define _P2RSEN                 0x80

//==============================================================================


//==============================================================================
//        CCP2CON Bits

extern __at(0x0F66) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned P2M0               : 1;
    unsigned P2M1               : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P2M                : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x0F66) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _DC2B1                  0x20
#define _P2M0                   0x40
#define _P2M1                   0x80

//==============================================================================

extern __at(0x0F67) __sfr CCPR2;
extern __at(0x0F67) __sfr CCPR2L;
extern __at(0x0F68) __sfr CCPR2H;

//==============================================================================
//        SSP2CON3 Bits

extern __at(0x0F69) __sfr SSP2CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP2CON3bits_t;

extern __at(0x0F69) volatile __SSP2CON3bits_t SSP2CON3bits;

#define _SSP2CON3_DHEN          0x01
#define _SSP2CON3_AHEN          0x02
#define _SSP2CON3_SBCDE         0x04
#define _SSP2CON3_SDAHT         0x08
#define _SSP2CON3_BOEN          0x10
#define _SSP2CON3_SCIE          0x20
#define _SSP2CON3_PCIE          0x40
#define _SSP2CON3_ACKTIM        0x80

//==============================================================================


//==============================================================================
//        SSP2MSK Bits

extern __at(0x0F6A) __sfr SSP2MSK;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSP2MSKbits_t;

extern __at(0x0F6A) volatile __SSP2MSKbits_t SSP2MSKbits;

#define _SSP2MSK_MSK0           0x01
#define _SSP2MSK_MSK1           0x02
#define _SSP2MSK_MSK2           0x04
#define _SSP2MSK_MSK3           0x08
#define _SSP2MSK_MSK4           0x10
#define _SSP2MSK_MSK5           0x20
#define _SSP2MSK_MSK6           0x40
#define _SSP2MSK_MSK7           0x80

//==============================================================================


//==============================================================================
//        SSP2CON2 Bits

extern __at(0x0F6B) __sfr SSP2CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP2CON2bits_t;

extern __at(0x0F6B) volatile __SSP2CON2bits_t SSP2CON2bits;

#define _SSP2CON2_SEN           0x01
#define _SSP2CON2_RSEN          0x02
#define _SSP2CON2_PEN           0x04
#define _SSP2CON2_RCEN          0x08
#define _SSP2CON2_ACKEN         0x10
#define _SSP2CON2_ACKDT         0x20
#define _SSP2CON2_ACKSTAT       0x40
#define _SSP2CON2_GCEN          0x80

//==============================================================================


//==============================================================================
//        SSP2CON1 Bits

extern __at(0x0F6C) __sfr SSP2CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP2CON1bits_t;

extern __at(0x0F6C) volatile __SSP2CON1bits_t SSP2CON1bits;

#define _SSP2CON1_SSPM0         0x01
#define _SSP2CON1_SSPM1         0x02
#define _SSP2CON1_SSPM2         0x04
#define _SSP2CON1_SSPM3         0x08
#define _SSP2CON1_CKP           0x10
#define _SSP2CON1_SSPEN         0x20
#define _SSP2CON1_SSPOV         0x40
#define _SSP2CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSP2STAT Bits

extern __at(0x0F6D) __sfr SSP2STAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSP2STATbits_t;

extern __at(0x0F6D) volatile __SSP2STATbits_t SSP2STATbits;

#define _SSP2STAT_BF            0x01
#define _SSP2STAT_UA            0x02
#define _SSP2STAT_R_NOT_W       0x04
#define _SSP2STAT_R             0x04
#define _SSP2STAT_NOT_W         0x04
#define _SSP2STAT_R_W           0x04
#define _SSP2STAT_NOT_WRITE     0x04
#define _SSP2STAT_S             0x08
#define _SSP2STAT_P             0x10
#define _SSP2STAT_D_NOT_A       0x20
#define _SSP2STAT_D             0x20
#define _SSP2STAT_NOT_A         0x20
#define _SSP2STAT_D_A           0x20
#define _SSP2STAT_NOT_ADDRESS   0x20
#define _SSP2STAT_CKE           0x40
#define _SSP2STAT_SMP           0x80

//==============================================================================

extern __at(0x0F6E) __sfr SSP2ADD;
extern __at(0x0F6F) __sfr SSP2BUF;

//==============================================================================
//        BAUD2CON Bits

extern __at(0x0F70) __sfr BAUD2CON;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned CKTXP              : 1;
    unsigned DTRXP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __BAUD2CONbits_t;

extern __at(0x0F70) volatile __BAUD2CONbits_t BAUD2CONbits;

#define _BAUD2CON_ABDEN         0x01
#define _BAUD2CON_WUE           0x02
#define _BAUD2CON_BRG16         0x08
#define _BAUD2CON_CKTXP         0x10
#define _BAUD2CON_SCKP          0x10
#define _BAUD2CON_DTRXP         0x20
#define _BAUD2CON_RCIDL         0x40
#define _BAUD2CON_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        BAUDCON2 Bits

extern __at(0x0F70) __sfr BAUDCON2;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned CKTXP              : 1;
    unsigned DTRXP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __BAUDCON2bits_t;

extern __at(0x0F70) volatile __BAUDCON2bits_t BAUDCON2bits;

#define _BAUDCON2_ABDEN         0x01
#define _BAUDCON2_WUE           0x02
#define _BAUDCON2_BRG16         0x08
#define _BAUDCON2_CKTXP         0x10
#define _BAUDCON2_SCKP          0x10
#define _BAUDCON2_DTRXP         0x20
#define _BAUDCON2_RCIDL         0x40
#define _BAUDCON2_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        RC2STA Bits

extern __at(0x0F71) __sfr RC2STA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RX9D2              : 1;
    unsigned OERR2              : 1;
    unsigned FERR2              : 1;
    unsigned ADEN               : 1;
    unsigned CREN2              : 1;
    unsigned SREN2              : 1;
    unsigned RX92               : 1;
    unsigned SPEN2              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADDEN2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RC2STAbits_t;

extern __at(0x0F71) volatile __RC2STAbits_t RC2STAbits;

#define _RC2STA_RX9D            0x01
#define _RC2STA_RX9D2           0x01
#define _RC2STA_OERR            0x02
#define _RC2STA_OERR2           0x02
#define _RC2STA_FERR            0x04
#define _RC2STA_FERR2           0x04
#define _RC2STA_ADDEN           0x08
#define _RC2STA_ADEN            0x08
#define _RC2STA_ADDEN2          0x08
#define _RC2STA_CREN            0x10
#define _RC2STA_CREN2           0x10
#define _RC2STA_SREN            0x20
#define _RC2STA_SREN2           0x20
#define _RC2STA_RX9             0x40
#define _RC2STA_RX92            0x40
#define _RC2STA_SPEN            0x80
#define _RC2STA_SPEN2           0x80

//==============================================================================


//==============================================================================
//        RCSTA2 Bits

extern __at(0x0F71) __sfr RCSTA2;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RX9D2              : 1;
    unsigned OERR2              : 1;
    unsigned FERR2              : 1;
    unsigned ADEN               : 1;
    unsigned CREN2              : 1;
    unsigned SREN2              : 1;
    unsigned RX92               : 1;
    unsigned SPEN2              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADDEN2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCSTA2bits_t;

extern __at(0x0F71) volatile __RCSTA2bits_t RCSTA2bits;

#define _RCSTA2_RX9D            0x01
#define _RCSTA2_RX9D2           0x01
#define _RCSTA2_OERR            0x02
#define _RCSTA2_OERR2           0x02
#define _RCSTA2_FERR            0x04
#define _RCSTA2_FERR2           0x04
#define _RCSTA2_ADDEN           0x08
#define _RCSTA2_ADEN            0x08
#define _RCSTA2_ADDEN2          0x08
#define _RCSTA2_CREN            0x10
#define _RCSTA2_CREN2           0x10
#define _RCSTA2_SREN            0x20
#define _RCSTA2_SREN2           0x20
#define _RCSTA2_RX9             0x40
#define _RCSTA2_RX92            0x40
#define _RCSTA2_SPEN            0x80
#define _RCSTA2_SPEN2           0x80

//==============================================================================


//==============================================================================
//        TX2STA Bits

extern __at(0x0F72) __sfr TX2STA;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TX9D2              : 1;
    unsigned TRMT2              : 1;
    unsigned BRGH2              : 1;
    unsigned SENDB2             : 1;
    unsigned SYNC2              : 1;
    unsigned TXEN2              : 1;
    unsigned TX92               : 1;
    unsigned CSRC2              : 1;
    };
  } __TX2STAbits_t;

extern __at(0x0F72) volatile __TX2STAbits_t TX2STAbits;

#define _TX2STA_TX9D            0x01
#define _TX2STA_TX9D2           0x01
#define _TX2STA_TRMT            0x02
#define _TX2STA_TRMT2           0x02
#define _TX2STA_BRGH            0x04
#define _TX2STA_BRGH2           0x04
#define _TX2STA_SENDB           0x08
#define _TX2STA_SENDB2          0x08
#define _TX2STA_SYNC            0x10
#define _TX2STA_SYNC2           0x10
#define _TX2STA_TXEN            0x20
#define _TX2STA_TXEN2           0x20
#define _TX2STA_TX9             0x40
#define _TX2STA_TX92            0x40
#define _TX2STA_CSRC            0x80
#define _TX2STA_CSRC2           0x80

//==============================================================================


//==============================================================================
//        TXSTA2 Bits

extern __at(0x0F72) __sfr TXSTA2;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TX9D2              : 1;
    unsigned TRMT2              : 1;
    unsigned BRGH2              : 1;
    unsigned SENDB2             : 1;
    unsigned SYNC2              : 1;
    unsigned TXEN2              : 1;
    unsigned TX92               : 1;
    unsigned CSRC2              : 1;
    };
  } __TXSTA2bits_t;

extern __at(0x0F72) volatile __TXSTA2bits_t TXSTA2bits;

#define _TXSTA2_TX9D            0x01
#define _TXSTA2_TX9D2           0x01
#define _TXSTA2_TRMT            0x02
#define _TXSTA2_TRMT2           0x02
#define _TXSTA2_BRGH            0x04
#define _TXSTA2_BRGH2           0x04
#define _TXSTA2_SENDB           0x08
#define _TXSTA2_SENDB2          0x08
#define _TXSTA2_SYNC            0x10
#define _TXSTA2_SYNC2           0x10
#define _TXSTA2_TXEN            0x20
#define _TXSTA2_TXEN2           0x20
#define _TXSTA2_TX9             0x40
#define _TXSTA2_TX92            0x40
#define _TXSTA2_CSRC            0x80
#define _TXSTA2_CSRC2           0x80

//==============================================================================

extern __at(0x0F73) __sfr TX2REG;
extern __at(0x0F73) __sfr TXREG2;
extern __at(0x0F74) __sfr RC2REG;
extern __at(0x0F74) __sfr RCREG2;
extern __at(0x0F75) __sfr SP2BRG;
extern __at(0x0F75) __sfr SPBRG2;
extern __at(0x0F76) __sfr SP2BRGH;
extern __at(0x0F76) __sfr SPBRGH2;

//==============================================================================
//        CM12CON Bits

extern __at(0x0F77) __sfr CM12CON;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned C1SYNC               : 1;
  unsigned C2HYS                : 1;
  unsigned C1HYS                : 1;
  unsigned C2RSEL               : 1;
  unsigned C1RSEL               : 1;
  unsigned MC2OUT               : 1;
  unsigned MC1OUT               : 1;
  } __CM12CONbits_t;

extern __at(0x0F77) volatile __CM12CONbits_t CM12CONbits;

#define _CM12CON_C2SYNC         0x01
#define _CM12CON_C1SYNC         0x02
#define _CM12CON_C2HYS          0x04
#define _CM12CON_C1HYS          0x08
#define _CM12CON_C2RSEL         0x10
#define _CM12CON_C1RSEL         0x20
#define _CM12CON_MC2OUT         0x40
#define _CM12CON_MC1OUT         0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0F77) __sfr CM2CON1;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned C1SYNC               : 1;
  unsigned C2HYS                : 1;
  unsigned C1HYS                : 1;
  unsigned C2RSEL               : 1;
  unsigned C1RSEL               : 1;
  unsigned MC2OUT               : 1;
  unsigned MC1OUT               : 1;
  } __CM2CON1bits_t;

extern __at(0x0F77) volatile __CM2CON1bits_t CM2CON1bits;

#define _C2SYNC                 0x01
#define _C1SYNC                 0x02
#define _C2HYS                  0x04
#define _C1HYS                  0x08
#define _C2RSEL                 0x10
#define _C1RSEL                 0x20
#define _MC2OUT                 0x40
#define _MC1OUT                 0x80

//==============================================================================


//==============================================================================
//        CM2CON Bits

extern __at(0x0F78) __sfr CM2CON;

typedef union
  {
  struct
    {
    unsigned C2CH0              : 1;
    unsigned C2CH1              : 1;
    unsigned C2R                : 1;
    unsigned C2SP               : 1;
    unsigned C2POL              : 1;
    unsigned C2OE               : 1;
    unsigned C2OUT              : 1;
    unsigned C2ON               : 1;
    };

  struct
    {
    unsigned C2CH               : 2;
    unsigned                    : 6;
    };
  } __CM2CONbits_t;

extern __at(0x0F78) volatile __CM2CONbits_t CM2CONbits;

#define _C2CH0                  0x01
#define _C2CH1                  0x02
#define _C2R                    0x04
#define _C2SP                   0x08
#define _C2POL                  0x10
#define _C2OE                   0x20
#define _C2OUT                  0x40
#define _C2ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x0F78) __sfr CM2CON0;

typedef union
  {
  struct
    {
    unsigned C2CH0              : 1;
    unsigned C2CH1              : 1;
    unsigned C2R                : 1;
    unsigned C2SP               : 1;
    unsigned C2POL              : 1;
    unsigned C2OE               : 1;
    unsigned C2OUT              : 1;
    unsigned C2ON               : 1;
    };

  struct
    {
    unsigned C2CH               : 2;
    unsigned                    : 6;
    };
  } __CM2CON0bits_t;

extern __at(0x0F78) volatile __CM2CON0bits_t CM2CON0bits;

#define _CM2CON0_C2CH0          0x01
#define _CM2CON0_C2CH1          0x02
#define _CM2CON0_C2R            0x04
#define _CM2CON0_C2SP           0x08
#define _CM2CON0_C2POL          0x10
#define _CM2CON0_C2OE           0x20
#define _CM2CON0_C2OUT          0x40
#define _CM2CON0_C2ON           0x80

//==============================================================================


//==============================================================================
//        CM1CON Bits

extern __at(0x0F79) __sfr CM1CON;

typedef union
  {
  struct
    {
    unsigned C1CH0              : 1;
    unsigned C1CH1              : 1;
    unsigned C1R                : 1;
    unsigned C1SP               : 1;
    unsigned C1POL              : 1;
    unsigned C1OE               : 1;
    unsigned C1OUT              : 1;
    unsigned C1ON               : 1;
    };

  struct
    {
    unsigned C1CH               : 2;
    unsigned                    : 6;
    };
  } __CM1CONbits_t;

extern __at(0x0F79) volatile __CM1CONbits_t CM1CONbits;

#define _C1CH0                  0x01
#define _C1CH1                  0x02
#define _C1R                    0x04
#define _C1SP                   0x08
#define _C1POL                  0x10
#define _C1OE                   0x20
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0F79) __sfr CM1CON0;

typedef union
  {
  struct
    {
    unsigned C1CH0              : 1;
    unsigned C1CH1              : 1;
    unsigned C1R                : 1;
    unsigned C1SP               : 1;
    unsigned C1POL              : 1;
    unsigned C1OE               : 1;
    unsigned C1OUT              : 1;
    unsigned C1ON               : 1;
    };

  struct
    {
    unsigned C1CH               : 2;
    unsigned                    : 6;
    };
  } __CM1CON0bits_t;

extern __at(0x0F79) volatile __CM1CON0bits_t CM1CON0bits;

#define _CM1CON0_C1CH0          0x01
#define _CM1CON0_C1CH1          0x02
#define _CM1CON0_C1R            0x04
#define _CM1CON0_C1SP           0x08
#define _CM1CON0_C1POL          0x10
#define _CM1CON0_C1OE           0x20
#define _CM1CON0_C1OUT          0x40
#define _CM1CON0_C1ON           0x80

//==============================================================================


//==============================================================================
//        PIE4 Bits

extern __at(0x0F7A) __sfr PIE4;

typedef struct
  {
  unsigned CCP3IE               : 1;
  unsigned CCP4IE               : 1;
  unsigned CCP5IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE4bits_t;

extern __at(0x0F7A) volatile __PIE4bits_t PIE4bits;

#define _CCP3IE                 0x01
#define _CCP4IE                 0x02
#define _CCP5IE                 0x04

//==============================================================================


//==============================================================================
//        PIR4 Bits

extern __at(0x0F7B) __sfr PIR4;

typedef struct
  {
  unsigned CCP3IF               : 1;
  unsigned CCP4IF               : 1;
  unsigned CCP5IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR4bits_t;

extern __at(0x0F7B) volatile __PIR4bits_t PIR4bits;

#define _CCP3IF                 0x01
#define _CCP4IF                 0x02
#define _CCP5IF                 0x04

//==============================================================================


//==============================================================================
//        IPR4 Bits

extern __at(0x0F7C) __sfr IPR4;

typedef struct
  {
  unsigned CCP3IP               : 1;
  unsigned CCP4IP               : 1;
  unsigned CCP5IP               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IPR4bits_t;

extern __at(0x0F7C) volatile __IPR4bits_t IPR4bits;

#define _CCP3IP                 0x01
#define _CCP4IP                 0x02
#define _CCP5IP                 0x04

//==============================================================================


//==============================================================================
//        PIE5 Bits

extern __at(0x0F7D) __sfr PIE5;

typedef struct
  {
  unsigned TMR4IE               : 1;
  unsigned TMR5IE               : 1;
  unsigned TMR6IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE5bits_t;

extern __at(0x0F7D) volatile __PIE5bits_t PIE5bits;

#define _TMR4IE                 0x01
#define _TMR5IE                 0x02
#define _TMR6IE                 0x04

//==============================================================================


//==============================================================================
//        PIR5 Bits

extern __at(0x0F7E) __sfr PIR5;

typedef struct
  {
  unsigned TMR4IF               : 1;
  unsigned TMR5IF               : 1;
  unsigned TMR6IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR5bits_t;

extern __at(0x0F7E) volatile __PIR5bits_t PIR5bits;

#define _TMR4IF                 0x01
#define _TMR5IF                 0x02
#define _TMR6IF                 0x04

//==============================================================================


//==============================================================================
//        IPR5 Bits

extern __at(0x0F7F) __sfr IPR5;

typedef struct
  {
  unsigned TMR4IP               : 1;
  unsigned TMR5IP               : 1;
  unsigned TMR6IP               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IPR5bits_t;

extern __at(0x0F7F) volatile __IPR5bits_t IPR5bits;

#define _TMR4IP                 0x01
#define _TMR5IP                 0x02
#define _TMR6IP                 0x04

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x0F80) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };

  struct
    {
    unsigned AN0                : 1;
    unsigned AN1                : 1;
    unsigned AN2                : 1;
    unsigned AN3                : 1;
    unsigned C1OUT              : 1;
    unsigned AN4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C12IN0M            : 1;
    unsigned C12IN1M            : 1;
    unsigned C2INP              : 1;
    unsigned C1INP              : 1;
    unsigned T0CKI              : 1;
    unsigned C2OUT              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned C12IN0N            : 1;
    unsigned C12IN1N            : 1;
    unsigned VREFM              : 1;
    unsigned VREFP              : 1;
    unsigned SRQ                : 1;
    unsigned SS                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VREFN              : 1;
    unsigned                    : 1;
    unsigned CCP5               : 1;
    unsigned NOT_SS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CVREF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIN              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DACOUT             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned HLVDIN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SS1                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_SS1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SRNQ               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTAbits_t;

extern __at(0x0F80) volatile __PORTAbits_t PORTAbits;

#define _PORTA_RA0              0x01
#define _PORTA_AN0              0x01
#define _PORTA_C12IN0M          0x01
#define _PORTA_C12IN0N          0x01
#define _PORTA_RA1              0x02
#define _PORTA_AN1              0x02
#define _PORTA_C12IN1M          0x02
#define _PORTA_C12IN1N          0x02
#define _PORTA_RA2              0x04
#define _PORTA_AN2              0x04
#define _PORTA_C2INP            0x04
#define _PORTA_VREFM            0x04
#define _PORTA_VREFN            0x04
#define _PORTA_CVREF            0x04
#define _PORTA_DACOUT           0x04
#define _PORTA_RA3              0x08
#define _PORTA_AN3              0x08
#define _PORTA_C1INP            0x08
#define _PORTA_VREFP            0x08
#define _PORTA_RA4              0x10
#define _PORTA_C1OUT            0x10
#define _PORTA_T0CKI            0x10
#define _PORTA_SRQ              0x10
#define _PORTA_CCP5             0x10
#define _PORTA_RA5              0x20
#define _PORTA_AN4              0x20
#define _PORTA_C2OUT            0x20
#define _PORTA_SS               0x20
#define _PORTA_NOT_SS           0x20
#define _PORTA_LVDIN            0x20
#define _PORTA_HLVDIN           0x20
#define _PORTA_SS1              0x20
#define _PORTA_NOT_SS1          0x20
#define _PORTA_SRNQ             0x20
#define _PORTA_RA6              0x40
#define _PORTA_RA7              0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0F81) __sfr PORTB;

typedef union
  {
  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };

  struct
    {
    unsigned INT0               : 1;
    unsigned INT1               : 1;
    unsigned INT2               : 1;
    unsigned CCP2               : 1;
    unsigned KBI0               : 1;
    unsigned KBI1               : 1;
    unsigned KBI2               : 1;
    unsigned KBI3               : 1;
    };

  struct
    {
    unsigned AN12               : 1;
    unsigned AN10               : 1;
    unsigned AN8                : 1;
    unsigned AN9                : 1;
    unsigned AN11               : 1;
    unsigned AN13               : 1;
    unsigned TX2                : 1;
    unsigned RX2                : 1;
    };

  struct
    {
    unsigned FLT0               : 1;
    unsigned C12IN3M            : 1;
    unsigned P1B                : 1;
    unsigned C12IN2M            : 1;
    unsigned T5G                : 1;
    unsigned T1G                : 1;
    unsigned CK2                : 1;
    unsigned DT2                : 1;
    };

  struct
    {
    unsigned SRI                : 1;
    unsigned C12IN3N            : 1;
    unsigned CTED1              : 1;
    unsigned C12IN2N            : 1;
    unsigned P1D                : 1;
    unsigned CCP3               : 1;
    unsigned PGC                : 1;
    unsigned PGD                : 1;
    };

  struct
    {
    unsigned CCP4               : 1;
    unsigned P1C                : 1;
    unsigned SDA2               : 1;
    unsigned CTED2              : 1;
    unsigned                    : 1;
    unsigned T3CKI              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SS2                : 1;
    unsigned SCL2               : 1;
    unsigned SDI2               : 1;
    unsigned P2A                : 1;
    unsigned                    : 1;
    unsigned P3A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NOT_SS2            : 1;
    unsigned SCK2               : 1;
    unsigned                    : 1;
    unsigned SDO2               : 1;
    unsigned                    : 1;
    unsigned P2B                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INT                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned KBI                : 4;
    };
  } __PORTBbits_t;

extern __at(0x0F81) volatile __PORTBbits_t PORTBbits;

#define _PORTB_RB0              0x01
#define _PORTB_INT0             0x01
#define _PORTB_AN12             0x01
#define _PORTB_FLT0             0x01
#define _PORTB_SRI              0x01
#define _PORTB_CCP4             0x01
#define _PORTB_SS2              0x01
#define _PORTB_NOT_SS2          0x01
#define _PORTB_RB1              0x02
#define _PORTB_INT1             0x02
#define _PORTB_AN10             0x02
#define _PORTB_C12IN3M          0x02
#define _PORTB_C12IN3N          0x02
#define _PORTB_P1C              0x02
#define _PORTB_SCL2             0x02
#define _PORTB_SCK2             0x02
#define _PORTB_RB2              0x04
#define _PORTB_INT2             0x04
#define _PORTB_AN8              0x04
#define _PORTB_P1B              0x04
#define _PORTB_CTED1            0x04
#define _PORTB_SDA2             0x04
#define _PORTB_SDI2             0x04
#define _PORTB_RB3              0x08
#define _PORTB_CCP2             0x08
#define _PORTB_AN9              0x08
#define _PORTB_C12IN2M          0x08
#define _PORTB_C12IN2N          0x08
#define _PORTB_CTED2            0x08
#define _PORTB_P2A              0x08
#define _PORTB_SDO2             0x08
#define _PORTB_RB4              0x10
#define _PORTB_KBI0             0x10
#define _PORTB_AN11             0x10
#define _PORTB_T5G              0x10
#define _PORTB_P1D              0x10
#define _PORTB_RB5              0x20
#define _PORTB_KBI1             0x20
#define _PORTB_AN13             0x20
#define _PORTB_T1G              0x20
#define _PORTB_CCP3             0x20
#define _PORTB_T3CKI            0x20
#define _PORTB_P3A              0x20
#define _PORTB_P2B              0x20
#define _PORTB_RB6              0x40
#define _PORTB_KBI2             0x40
#define _PORTB_TX2              0x40
#define _PORTB_CK2              0x40
#define _PORTB_PGC              0x40
#define _PORTB_RB7              0x80
#define _PORTB_KBI3             0x80
#define _PORTB_RX2              0x80
#define _PORTB_DT2              0x80
#define _PORTB_PGD              0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0F82) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };

  struct
    {
    unsigned T1OSO              : 1;
    unsigned T1OSI              : 1;
    unsigned T5CKI              : 1;
    unsigned SCK                : 1;
    unsigned SDI                : 1;
    unsigned SDO                : 1;
    unsigned TX                 : 1;
    unsigned RX                 : 1;
    };

  struct
    {
    unsigned P2B                : 1;
    unsigned P2A                : 1;
    unsigned P1A                : 1;
    unsigned SCL                : 1;
    unsigned SDA                : 1;
    unsigned SDO1               : 1;
    unsigned CK                 : 1;
    unsigned RX1                : 1;
    };

  struct
    {
    unsigned T1CKI              : 1;
    unsigned CCP2               : 1;
    unsigned CCP1               : 1;
    unsigned SCK1               : 1;
    unsigned SDI1               : 1;
    unsigned AN17               : 1;
    unsigned TX1                : 1;
    unsigned DT1                : 1;
    };

  struct
    {
    unsigned T3CKI              : 1;
    unsigned                    : 1;
    unsigned CTPLS              : 1;
    unsigned SCL1               : 1;
    unsigned SDA1               : 1;
    unsigned                    : 1;
    unsigned CK1                : 1;
    unsigned AN19               : 1;
    };

  struct
    {
    unsigned T3G                : 1;
    unsigned                    : 1;
    unsigned AN14               : 1;
    unsigned AN15               : 1;
    unsigned AN16               : 1;
    unsigned                    : 1;
    unsigned AN18               : 1;
    unsigned P3B                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP3               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned P3A                : 1;
    unsigned                    : 1;
    };
  } __PORTCbits_t;

extern __at(0x0F82) volatile __PORTCbits_t PORTCbits;

#define _PORTC_RC0              0x01
#define _PORTC_T1OSO            0x01
#define _PORTC_P2B              0x01
#define _PORTC_T1CKI            0x01
#define _PORTC_T3CKI            0x01
#define _PORTC_T3G              0x01
#define _PORTC_RC1              0x02
#define _PORTC_T1OSI            0x02
#define _PORTC_P2A              0x02
#define _PORTC_CCP2             0x02
#define _PORTC_RC2              0x04
#define _PORTC_T5CKI            0x04
#define _PORTC_P1A              0x04
#define _PORTC_CCP1             0x04
#define _PORTC_CTPLS            0x04
#define _PORTC_AN14             0x04
#define _PORTC_RC3              0x08
#define _PORTC_SCK              0x08
#define _PORTC_SCL              0x08
#define _PORTC_SCK1             0x08
#define _PORTC_SCL1             0x08
#define _PORTC_AN15             0x08
#define _PORTC_RC4              0x10
#define _PORTC_SDI              0x10
#define _PORTC_SDA              0x10
#define _PORTC_SDI1             0x10
#define _PORTC_SDA1             0x10
#define _PORTC_AN16             0x10
#define _PORTC_RC5              0x20
#define _PORTC_SDO              0x20
#define _PORTC_SDO1             0x20
#define _PORTC_AN17             0x20
#define _PORTC_RC6              0x40
#define _PORTC_TX               0x40
#define _PORTC_CK               0x40
#define _PORTC_TX1              0x40
#define _PORTC_CK1              0x40
#define _PORTC_AN18             0x40
#define _PORTC_CCP3             0x40
#define _PORTC_P3A              0x40
#define _PORTC_RC7              0x80
#define _PORTC_RX               0x80
#define _PORTC_RX1              0x80
#define _PORTC_DT1              0x80
#define _PORTC_AN19             0x80
#define _PORTC_P3B              0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0F84) __sfr PORTE;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RE3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MCLR               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_MCLR           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VPP                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTEbits_t;

extern __at(0x0F84) volatile __PORTEbits_t PORTEbits;

#define _RE3                    0x08
#define _MCLR                   0x08
#define _NOT_MCLR               0x08
#define _VPP                    0x08

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x0F89) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x0F89) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x0F8A) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x0F8A) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x0F8B) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x0F8B) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        DDRA Bits

extern __at(0x0F92) __sfr DDRA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned TRISA6             : 1;
    unsigned TRISA7             : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };
  } __DDRAbits_t;

extern __at(0x0F92) volatile __DDRAbits_t DDRAbits;

#define _TRISA0                 0x01
#define _RA0                    0x01
#define _TRISA1                 0x02
#define _RA1                    0x02
#define _TRISA2                 0x04
#define _RA2                    0x04
#define _TRISA3                 0x08
#define _RA3                    0x08
#define _TRISA4                 0x10
#define _RA4                    0x10
#define _TRISA5                 0x20
#define _RA5                    0x20
#define _TRISA6                 0x40
#define _RA6                    0x40
#define _TRISA7                 0x80
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0F92) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned TRISA6             : 1;
    unsigned TRISA7             : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };
  } __TRISAbits_t;

extern __at(0x0F92) volatile __TRISAbits_t TRISAbits;

#define _TRISA_TRISA0           0x01
#define _TRISA_RA0              0x01
#define _TRISA_TRISA1           0x02
#define _TRISA_RA1              0x02
#define _TRISA_TRISA2           0x04
#define _TRISA_RA2              0x04
#define _TRISA_TRISA3           0x08
#define _TRISA_RA3              0x08
#define _TRISA_TRISA4           0x10
#define _TRISA_RA4              0x10
#define _TRISA_TRISA5           0x20
#define _TRISA_RA5              0x20
#define _TRISA_TRISA6           0x40
#define _TRISA_RA6              0x40
#define _TRISA_TRISA7           0x80
#define _TRISA_RA7              0x80

//==============================================================================


//==============================================================================
//        DDRB Bits

extern __at(0x0F93) __sfr DDRB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __DDRBbits_t;

extern __at(0x0F93) volatile __DDRBbits_t DDRBbits;

#define _TRISB0                 0x01
#define _RB0                    0x01
#define _TRISB1                 0x02
#define _RB1                    0x02
#define _TRISB2                 0x04
#define _RB2                    0x04
#define _TRISB3                 0x08
#define _RB3                    0x08
#define _TRISB4                 0x10
#define _RB4                    0x10
#define _TRISB5                 0x20
#define _RB5                    0x20
#define _TRISB6                 0x40
#define _RB6                    0x40
#define _TRISB7                 0x80
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0F93) __sfr TRISB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __TRISBbits_t;

extern __at(0x0F93) volatile __TRISBbits_t TRISBbits;

#define _TRISB_TRISB0           0x01
#define _TRISB_RB0              0x01
#define _TRISB_TRISB1           0x02
#define _TRISB_RB1              0x02
#define _TRISB_TRISB2           0x04
#define _TRISB_RB2              0x04
#define _TRISB_TRISB3           0x08
#define _TRISB_RB3              0x08
#define _TRISB_TRISB4           0x10
#define _TRISB_RB4              0x10
#define _TRISB_TRISB5           0x20
#define _TRISB_RB5              0x20
#define _TRISB_TRISB6           0x40
#define _TRISB_RB6              0x40
#define _TRISB_TRISB7           0x80
#define _TRISB_RB7              0x80

//==============================================================================


//==============================================================================
//        DDRC Bits

extern __at(0x0F94) __sfr DDRC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __DDRCbits_t;

extern __at(0x0F94) volatile __DDRCbits_t DDRCbits;

#define _TRISC0                 0x01
#define _RC0                    0x01
#define _TRISC1                 0x02
#define _RC1                    0x02
#define _TRISC2                 0x04
#define _RC2                    0x04
#define _TRISC3                 0x08
#define _RC3                    0x08
#define _TRISC4                 0x10
#define _RC4                    0x10
#define _TRISC5                 0x20
#define _RC5                    0x20
#define _TRISC6                 0x40
#define _RC6                    0x40
#define _TRISC7                 0x80
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0F94) __sfr TRISC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __TRISCbits_t;

extern __at(0x0F94) volatile __TRISCbits_t TRISCbits;

#define _TRISC_TRISC0           0x01
#define _TRISC_RC0              0x01
#define _TRISC_TRISC1           0x02
#define _TRISC_RC1              0x02
#define _TRISC_TRISC2           0x04
#define _TRISC_RC2              0x04
#define _TRISC_TRISC3           0x08
#define _TRISC_RC3              0x08
#define _TRISC_TRISC4           0x10
#define _TRISC_RC4              0x10
#define _TRISC_TRISC5           0x20
#define _TRISC_RC5              0x20
#define _TRISC_TRISC6           0x40
#define _TRISC_RC6              0x40
#define _TRISC_TRISC7           0x80
#define _TRISC_RC7              0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0F96) __sfr TRISE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUE3                : 1;
  } __TRISEbits_t;

extern __at(0x0F96) volatile __TRISEbits_t TRISEbits;

#define _WPUE3                  0x80

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0F9B) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned PLLEN              : 1;
    unsigned INTSRC             : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0F9B) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20
#define _PLLEN                  0x40
#define _INTSRC                 0x80

//==============================================================================


//==============================================================================
//        HLVDCON Bits

extern __at(0x0F9C) __sfr HLVDCON;

typedef union
  {
  struct
    {
    unsigned HLVDL0             : 1;
    unsigned HLVDL1             : 1;
    unsigned HLVDL2             : 1;
    unsigned HLVDL3             : 1;
    unsigned HLVDEN             : 1;
    unsigned IRVST              : 1;
    unsigned BGVST              : 1;
    unsigned VDIRMAG            : 1;
    };

  struct
    {
    unsigned LVDL0              : 1;
    unsigned LVDL1              : 1;
    unsigned LVDL2              : 1;
    unsigned LVDL3              : 1;
    unsigned LVDEN              : 1;
    unsigned IVRST              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV0               : 1;
    unsigned LVV1               : 1;
    unsigned LVV2               : 1;
    unsigned LVV3               : 1;
    unsigned                    : 1;
    unsigned BGST               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned HLVDL              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned LVDL               : 4;
    unsigned                    : 4;
    };
  } __HLVDCONbits_t;

extern __at(0x0F9C) volatile __HLVDCONbits_t HLVDCONbits;

#define _HLVDL0                 0x01
#define _LVDL0                  0x01
#define _LVV0                   0x01
#define _HLVDL1                 0x02
#define _LVDL1                  0x02
#define _LVV1                   0x02
#define _HLVDL2                 0x04
#define _LVDL2                  0x04
#define _LVV2                   0x04
#define _HLVDL3                 0x08
#define _LVDL3                  0x08
#define _LVV3                   0x08
#define _HLVDEN                 0x10
#define _LVDEN                  0x10
#define _IRVST                  0x20
#define _IVRST                  0x20
#define _BGST                   0x20
#define _BGVST                  0x40
#define _VDIRMAG                0x80

//==============================================================================


//==============================================================================
//        LVDCON Bits

extern __at(0x0F9C) __sfr LVDCON;

typedef union
  {
  struct
    {
    unsigned HLVDL0             : 1;
    unsigned HLVDL1             : 1;
    unsigned HLVDL2             : 1;
    unsigned HLVDL3             : 1;
    unsigned HLVDEN             : 1;
    unsigned IRVST              : 1;
    unsigned BGVST              : 1;
    unsigned VDIRMAG            : 1;
    };

  struct
    {
    unsigned LVDL0              : 1;
    unsigned LVDL1              : 1;
    unsigned LVDL2              : 1;
    unsigned LVDL3              : 1;
    unsigned LVDEN              : 1;
    unsigned IVRST              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV0               : 1;
    unsigned LVV1               : 1;
    unsigned LVV2               : 1;
    unsigned LVV3               : 1;
    unsigned                    : 1;
    unsigned BGST               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVDL               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned LVV                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned HLVDL              : 4;
    unsigned                    : 4;
    };
  } __LVDCONbits_t;

extern __at(0x0F9C) volatile __LVDCONbits_t LVDCONbits;

#define _LVDCON_HLVDL0          0x01
#define _LVDCON_LVDL0           0x01
#define _LVDCON_LVV0            0x01
#define _LVDCON_HLVDL1          0x02
#define _LVDCON_LVDL1           0x02
#define _LVDCON_LVV1            0x02
#define _LVDCON_HLVDL2          0x04
#define _LVDCON_LVDL2           0x04
#define _LVDCON_LVV2            0x04
#define _LVDCON_HLVDL3          0x08
#define _LVDCON_LVDL3           0x08
#define _LVDCON_LVV3            0x08
#define _LVDCON_HLVDEN          0x10
#define _LVDCON_LVDEN           0x10
#define _LVDCON_IRVST           0x20
#define _LVDCON_IVRST           0x20
#define _LVDCON_BGST            0x20
#define _LVDCON_BGVST           0x40
#define _LVDCON_VDIRMAG         0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0F9D) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned CCP1IE             : 1;
    unsigned SSP1IE             : 1;
    unsigned TX1IE              : 1;
    unsigned RC1IE              : 1;
    unsigned ADIE               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIE              : 1;
    unsigned TXIE               : 1;
    unsigned RCIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x0F9D) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSP1IE                 0x08
#define _SSPIE                  0x08
#define _TX1IE                  0x10
#define _TXIE                   0x10
#define _RC1IE                  0x20
#define _RCIE                   0x20
#define _ADIE                   0x40

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0F9E) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned CCP1IF             : 1;
    unsigned SSP1IF             : 1;
    unsigned TX1IF              : 1;
    unsigned RC1IF              : 1;
    unsigned ADIF               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIF              : 1;
    unsigned TXIF               : 1;
    unsigned RCIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x0F9E) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSP1IF                 0x08
#define _SSPIF                  0x08
#define _TX1IF                  0x10
#define _TXIF                   0x10
#define _RC1IF                  0x20
#define _RCIF                   0x20
#define _ADIF                   0x40

//==============================================================================


//==============================================================================
//        IPR1 Bits

extern __at(0x0F9F) __sfr IPR1;

typedef union
  {
  struct
    {
    unsigned TMR1IP             : 1;
    unsigned TMR2IP             : 1;
    unsigned CCP1IP             : 1;
    unsigned SSP1IP             : 1;
    unsigned TX1IP              : 1;
    unsigned RC1IP              : 1;
    unsigned ADIP               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIP              : 1;
    unsigned TXIP               : 1;
    unsigned RCIP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR1bits_t;

extern __at(0x0F9F) volatile __IPR1bits_t IPR1bits;

#define _TMR1IP                 0x01
#define _TMR2IP                 0x02
#define _CCP1IP                 0x04
#define _SSP1IP                 0x08
#define _SSPIP                  0x08
#define _TX1IP                  0x10
#define _TXIP                   0x10
#define _RC1IP                  0x20
#define _RCIP                   0x20
#define _ADIP                   0x40

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0FA0) __sfr PIE2;

typedef union
  {
  struct
    {
    unsigned CCP2IE             : 1;
    unsigned TMR3IE             : 1;
    unsigned HLVDIE             : 1;
    unsigned BCL1IE             : 1;
    unsigned EEIE               : 1;
    unsigned C2IE               : 1;
    unsigned C1IE               : 1;
    unsigned OSCFIE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIE              : 1;
    unsigned BCLIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE2bits_t;

extern __at(0x0FA0) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _TMR3IE                 0x02
#define _HLVDIE                 0x04
#define _LVDIE                  0x04
#define _BCL1IE                 0x08
#define _BCLIE                  0x08
#define _EEIE                   0x10
#define _C2IE                   0x20
#define _C1IE                   0x40
#define _OSCFIE                 0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0FA1) __sfr PIR2;

typedef union
  {
  struct
    {
    unsigned CCP2IF             : 1;
    unsigned TMR3IF             : 1;
    unsigned HLVDIF             : 1;
    unsigned BCL1IF             : 1;
    unsigned EEIF               : 1;
    unsigned C2IF               : 1;
    unsigned C1IF               : 1;
    unsigned OSCFIF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIF              : 1;
    unsigned BCLIF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR2bits_t;

extern __at(0x0FA1) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _TMR3IF                 0x02
#define _HLVDIF                 0x04
#define _LVDIF                  0x04
#define _BCL1IF                 0x08
#define _BCLIF                  0x08
#define _EEIF                   0x10
#define _C2IF                   0x20
#define _C1IF                   0x40
#define _OSCFIF                 0x80

//==============================================================================


//==============================================================================
//        IPR2 Bits

extern __at(0x0FA2) __sfr IPR2;

typedef union
  {
  struct
    {
    unsigned CCP2IP             : 1;
    unsigned TMR3IP             : 1;
    unsigned HLVDIP             : 1;
    unsigned BCL1IP             : 1;
    unsigned EEIP               : 1;
    unsigned C2IP               : 1;
    unsigned C1IP               : 1;
    unsigned OSCFIP             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIP              : 1;
    unsigned BCLIP              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR2bits_t;

extern __at(0x0FA2) volatile __IPR2bits_t IPR2bits;

#define _CCP2IP                 0x01
#define _TMR3IP                 0x02
#define _HLVDIP                 0x04
#define _LVDIP                  0x04
#define _BCL1IP                 0x08
#define _BCLIP                  0x08
#define _EEIP                   0x10
#define _C2IP                   0x20
#define _C1IP                   0x40
#define _OSCFIP                 0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0FA3) __sfr PIE3;

typedef struct
  {
  unsigned TMR1GIE              : 1;
  unsigned TMR3GIE              : 1;
  unsigned TMR5GIE              : 1;
  unsigned CTMUIE               : 1;
  unsigned TX2IE                : 1;
  unsigned RC2IE                : 1;
  unsigned BCL2IE               : 1;
  unsigned SSP2IE               : 1;
  } __PIE3bits_t;

extern __at(0x0FA3) volatile __PIE3bits_t PIE3bits;

#define _TMR1GIE                0x01
#define _TMR3GIE                0x02
#define _TMR5GIE                0x04
#define _CTMUIE                 0x08
#define _TX2IE                  0x10
#define _RC2IE                  0x20
#define _BCL2IE                 0x40
#define _SSP2IE                 0x80

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0FA4) __sfr PIR3;

typedef struct
  {
  unsigned TMR1GIF              : 1;
  unsigned TMR3GIF              : 1;
  unsigned TMR5GIF              : 1;
  unsigned CTMUIF               : 1;
  unsigned TX2IF                : 1;
  unsigned RC2IF                : 1;
  unsigned BCL2IF               : 1;
  unsigned SSP2IF               : 1;
  } __PIR3bits_t;

extern __at(0x0FA4) volatile __PIR3bits_t PIR3bits;

#define _TMR1GIF                0x01
#define _TMR3GIF                0x02
#define _TMR5GIF                0x04
#define _CTMUIF                 0x08
#define _TX2IF                  0x10
#define _RC2IF                  0x20
#define _BCL2IF                 0x40
#define _SSP2IF                 0x80

//==============================================================================


//==============================================================================
//        IPR3 Bits

extern __at(0x0FA5) __sfr IPR3;

typedef struct
  {
  unsigned TMR1GIP              : 1;
  unsigned TMR3GIP              : 1;
  unsigned TMR5GIP              : 1;
  unsigned CTMUIP               : 1;
  unsigned TX2IP                : 1;
  unsigned RC2IP                : 1;
  unsigned BCL2IP               : 1;
  unsigned SSP2IP               : 1;
  } __IPR3bits_t;

extern __at(0x0FA5) volatile __IPR3bits_t IPR3bits;

#define _TMR1GIP                0x01
#define _TMR3GIP                0x02
#define _TMR5GIP                0x04
#define _CTMUIP                 0x08
#define _TX2IP                  0x10
#define _RC2IP                  0x20
#define _BCL2IP                 0x40
#define _SSP2IP                 0x80

//==============================================================================


//==============================================================================
//        EECON1 Bits

extern __at(0x0FA6) __sfr EECON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned                      : 1;
  unsigned CFGS                 : 1;
  unsigned EEPGD                : 1;
  } __EECON1bits_t;

extern __at(0x0FA6) volatile __EECON1bits_t EECON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _CFGS                   0x40
#define _EEPGD                  0x80

//==============================================================================

extern __at(0x0FA7) __sfr EECON2;
extern __at(0x0FA8) __sfr EEDATA;

//==============================================================================
//        EEADR Bits

extern __at(0x0FA9) __sfr EEADR;

typedef struct
  {
  unsigned EEADR0               : 1;
  unsigned EEADR1               : 1;
  unsigned EEADR2               : 1;
  unsigned EEADR3               : 1;
  unsigned EEADR4               : 1;
  unsigned EEADR5               : 1;
  unsigned EEADR6               : 1;
  unsigned EEADR7               : 1;
  } __EEADRbits_t;

extern __at(0x0FA9) volatile __EEADRbits_t EEADRbits;

#define _EEADR0                 0x01
#define _EEADR1                 0x02
#define _EEADR2                 0x04
#define _EEADR3                 0x08
#define _EEADR4                 0x10
#define _EEADR5                 0x20
#define _EEADR6                 0x40
#define _EEADR7                 0x80

//==============================================================================


//==============================================================================
//        EEADRH Bits

extern __at(0x0FAA) __sfr EEADRH;

typedef struct
  {
  unsigned EEADR8               : 1;
  unsigned EEADR9               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __EEADRHbits_t;

extern __at(0x0FAA) volatile __EEADRHbits_t EEADRHbits;

#define _EEADR8                 0x01
#define _EEADR9                 0x02

//==============================================================================


//==============================================================================
//        RC1STA Bits

extern __at(0x0FAB) __sfr RC1STA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RX9D1              : 1;
    unsigned OERR1              : 1;
    unsigned FERR1              : 1;
    unsigned ADEN               : 1;
    unsigned CREN1              : 1;
    unsigned SREN1              : 1;
    unsigned RX91               : 1;
    unsigned SPEN1              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADDEN1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RC1STAbits_t;

extern __at(0x0FAB) volatile __RC1STAbits_t RC1STAbits;

#define _RX9D                   0x01
#define _RX9D1                  0x01
#define _OERR                   0x02
#define _OERR1                  0x02
#define _FERR                   0x04
#define _FERR1                  0x04
#define _ADDEN                  0x08
#define _ADEN                   0x08
#define _ADDEN1                 0x08
#define _CREN                   0x10
#define _CREN1                  0x10
#define _SREN                   0x20
#define _SREN1                  0x20
#define _RX9                    0x40
#define _RX91                   0x40
#define _SPEN                   0x80
#define _SPEN1                  0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x0FAB) __sfr RCSTA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RX9D1              : 1;
    unsigned OERR1              : 1;
    unsigned FERR1              : 1;
    unsigned ADEN               : 1;
    unsigned CREN1              : 1;
    unsigned SREN1              : 1;
    unsigned RX91               : 1;
    unsigned SPEN1              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADDEN1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCSTAbits_t;

extern __at(0x0FAB) volatile __RCSTAbits_t RCSTAbits;

#define _RCSTA_RX9D             0x01
#define _RCSTA_RX9D1            0x01
#define _RCSTA_OERR             0x02
#define _RCSTA_OERR1            0x02
#define _RCSTA_FERR             0x04
#define _RCSTA_FERR1            0x04
#define _RCSTA_ADDEN            0x08
#define _RCSTA_ADEN             0x08
#define _RCSTA_ADDEN1           0x08
#define _RCSTA_CREN             0x10
#define _RCSTA_CREN1            0x10
#define _RCSTA_SREN             0x20
#define _RCSTA_SREN1            0x20
#define _RCSTA_RX9              0x40
#define _RCSTA_RX91             0x40
#define _RCSTA_SPEN             0x80
#define _RCSTA_SPEN1            0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x0FAB) __sfr RCSTA1;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RX9D1              : 1;
    unsigned OERR1              : 1;
    unsigned FERR1              : 1;
    unsigned ADEN               : 1;
    unsigned CREN1              : 1;
    unsigned SREN1              : 1;
    unsigned RX91               : 1;
    unsigned SPEN1              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADDEN1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCSTA1bits_t;

extern __at(0x0FAB) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_RX9D1           0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_OERR1           0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_FERR1           0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_ADEN            0x08
#define _RCSTA1_ADDEN1          0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_CREN1           0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_SREN1           0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_RX91            0x40
#define _RCSTA1_SPEN            0x80
#define _RCSTA1_SPEN1           0x80

//==============================================================================


//==============================================================================
//        TX1STA Bits

extern __at(0x0FAC) __sfr TX1STA;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TX9D1              : 1;
    unsigned TRMT1              : 1;
    unsigned BRGH1              : 1;
    unsigned SENDB1             : 1;
    unsigned SYNC1              : 1;
    unsigned TXEN1              : 1;
    unsigned TX91               : 1;
    unsigned CSRC1              : 1;
    };
  } __TX1STAbits_t;

extern __at(0x0FAC) volatile __TX1STAbits_t TX1STAbits;

#define _TX9D                   0x01
#define _TX9D1                  0x01
#define _TRMT                   0x02
#define _TRMT1                  0x02
#define _BRGH                   0x04
#define _BRGH1                  0x04
#define _SENDB                  0x08
#define _SENDB1                 0x08
#define _SYNC                   0x10
#define _SYNC1                  0x10
#define _TXEN                   0x20
#define _TXEN1                  0x20
#define _TX9                    0x40
#define _TX91                   0x40
#define _CSRC                   0x80
#define _CSRC1                  0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x0FAC) __sfr TXSTA;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TX9D1              : 1;
    unsigned TRMT1              : 1;
    unsigned BRGH1              : 1;
    unsigned SENDB1             : 1;
    unsigned SYNC1              : 1;
    unsigned TXEN1              : 1;
    unsigned TX91               : 1;
    unsigned CSRC1              : 1;
    };
  } __TXSTAbits_t;

extern __at(0x0FAC) volatile __TXSTAbits_t TXSTAbits;

#define _TXSTA_TX9D             0x01
#define _TXSTA_TX9D1            0x01
#define _TXSTA_TRMT             0x02
#define _TXSTA_TRMT1            0x02
#define _TXSTA_BRGH             0x04
#define _TXSTA_BRGH1            0x04
#define _TXSTA_SENDB            0x08
#define _TXSTA_SENDB1           0x08
#define _TXSTA_SYNC             0x10
#define _TXSTA_SYNC1            0x10
#define _TXSTA_TXEN             0x20
#define _TXSTA_TXEN1            0x20
#define _TXSTA_TX9              0x40
#define _TXSTA_TX91             0x40
#define _TXSTA_CSRC             0x80
#define _TXSTA_CSRC1            0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x0FAC) __sfr TXSTA1;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TX9D1              : 1;
    unsigned TRMT1              : 1;
    unsigned BRGH1              : 1;
    unsigned SENDB1             : 1;
    unsigned SYNC1              : 1;
    unsigned TXEN1              : 1;
    unsigned TX91               : 1;
    unsigned CSRC1              : 1;
    };
  } __TXSTA1bits_t;

extern __at(0x0FAC) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TX9D1           0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_TRMT1           0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_BRGH1           0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SENDB1          0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_SYNC1           0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TXEN1           0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_TX91            0x40
#define _TXSTA1_CSRC            0x80
#define _TXSTA1_CSRC1           0x80

//==============================================================================

extern __at(0x0FAD) __sfr TX1REG;
extern __at(0x0FAD) __sfr TXREG;
extern __at(0x0FAD) __sfr TXREG1;
extern __at(0x0FAE) __sfr RC1REG;
extern __at(0x0FAE) __sfr RCREG;
extern __at(0x0FAE) __sfr RCREG1;
extern __at(0x0FAF) __sfr SP1BRG;
extern __at(0x0FAF) __sfr SPBRG;
extern __at(0x0FAF) __sfr SPBRG1;
extern __at(0x0FB0) __sfr SP1BRGH;
extern __at(0x0FB0) __sfr SPBRGH;
extern __at(0x0FB0) __sfr SPBRGH1;

//==============================================================================
//        T3CON Bits

extern __at(0x0FB1) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned TMR3ON             : 1;
    unsigned T3RD16             : 1;
    unsigned NOT_T3SYNC         : 1;
    unsigned T3SOSCEN           : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned TMR3CS0            : 1;
    unsigned TMR3CS1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3OSCEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR3CS             : 2;
    };
  } __T3CONbits_t;

extern __at(0x0FB1) volatile __T3CONbits_t T3CONbits;

#define _TMR3ON                 0x01
#define _T3RD16                 0x02
#define _NOT_T3SYNC             0x04
#define _T3SOSCEN               0x08
#define _T3OSCEN                0x08
#define _T3CKPS0                0x10
#define _T3CKPS1                0x20
#define _TMR3CS0                0x40
#define _TMR3CS1                0x80

//==============================================================================

extern __at(0x0FB2) __sfr TMR3;
extern __at(0x0FB2) __sfr TMR3L;
extern __at(0x0FB3) __sfr TMR3H;

//==============================================================================
//        T3GCON Bits

extern __at(0x0FB4) __sfr T3GCON;

typedef union
  {
  struct
    {
    unsigned T3GSS0             : 1;
    unsigned T3GSS1             : 1;
    unsigned T3GVAL             : 1;
    unsigned T3GGO_NOT_DONE     : 1;
    unsigned T3GSPM             : 1;
    unsigned T3GTM              : 1;
    unsigned T3GPOL             : 1;
    unsigned TMR3GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3G_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T3GSS              : 2;
    unsigned                    : 6;
    };
  } __T3GCONbits_t;

extern __at(0x0FB4) volatile __T3GCONbits_t T3GCONbits;

#define _T3GSS0                 0x01
#define _T3GSS1                 0x02
#define _T3GVAL                 0x04
#define _T3GGO_NOT_DONE         0x08
#define _T3G_DONE               0x08
#define _T3GGO                  0x08
#define _T3GSPM                 0x10
#define _T3GTM                  0x20
#define _T3GPOL                 0x40
#define _TMR3GE                 0x80

//==============================================================================


//==============================================================================
//        ECCP1AS Bits

extern __at(0x0FB6) __sfr ECCP1AS;

typedef union
  {
  struct
    {
    unsigned P1SSBD0            : 1;
    unsigned P1SSBD1            : 1;
    unsigned P1SSAC0            : 1;
    unsigned P1SSAC1            : 1;
    unsigned CCP1AS0            : 1;
    unsigned CCP1AS1            : 1;
    unsigned CCP1AS2            : 1;
    unsigned CCP1ASE            : 1;
    };

  struct
    {
    unsigned PSS1BD0            : 1;
    unsigned PSS1BD1            : 1;
    unsigned PSS1AC0            : 1;
    unsigned PSS1AC1            : 1;
    unsigned ECCPAS0            : 1;
    unsigned ECCPAS1            : 1;
    unsigned ECCPAS2            : 1;
    unsigned ECCPASE            : 1;
    };

  struct
    {
    unsigned PSSBD0             : 1;
    unsigned PSSBD1             : 1;
    unsigned PSSAC0             : 1;
    unsigned PSSAC1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PSSBD              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PSS1BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned P1SSBD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSSAC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned P1SSAC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS1AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CCP1AS             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCPAS             : 3;
    unsigned                    : 1;
    };
  } __ECCP1ASbits_t;

extern __at(0x0FB6) volatile __ECCP1ASbits_t ECCP1ASbits;

#define _P1SSBD0                0x01
#define _PSS1BD0                0x01
#define _PSSBD0                 0x01
#define _P1SSBD1                0x02
#define _PSS1BD1                0x02
#define _PSSBD1                 0x02
#define _P1SSAC0                0x04
#define _PSS1AC0                0x04
#define _PSSAC0                 0x04
#define _P1SSAC1                0x08
#define _PSS1AC1                0x08
#define _PSSAC1                 0x08
#define _CCP1AS0                0x10
#define _ECCPAS0                0x10
#define _CCP1AS1                0x20
#define _ECCPAS1                0x20
#define _CCP1AS2                0x40
#define _ECCPAS2                0x40
#define _CCP1ASE                0x80
#define _ECCPASE                0x80

//==============================================================================


//==============================================================================
//        ECCPAS Bits

extern __at(0x0FB6) __sfr ECCPAS;

typedef union
  {
  struct
    {
    unsigned P1SSBD0            : 1;
    unsigned P1SSBD1            : 1;
    unsigned P1SSAC0            : 1;
    unsigned P1SSAC1            : 1;
    unsigned CCP1AS0            : 1;
    unsigned CCP1AS1            : 1;
    unsigned CCP1AS2            : 1;
    unsigned CCP1ASE            : 1;
    };

  struct
    {
    unsigned PSS1BD0            : 1;
    unsigned PSS1BD1            : 1;
    unsigned PSS1AC0            : 1;
    unsigned PSS1AC1            : 1;
    unsigned ECCPAS0            : 1;
    unsigned ECCPAS1            : 1;
    unsigned ECCPAS2            : 1;
    unsigned ECCPASE            : 1;
    };

  struct
    {
    unsigned PSSBD0             : 1;
    unsigned PSSBD1             : 1;
    unsigned PSSAC0             : 1;
    unsigned PSSAC1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PSS1BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PSSBD              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned P1SSBD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSSAC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned P1SSAC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS1AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCPAS             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned CCP1AS             : 3;
    unsigned                    : 1;
    };
  } __ECCPASbits_t;

extern __at(0x0FB6) volatile __ECCPASbits_t ECCPASbits;

#define _ECCPAS_P1SSBD0         0x01
#define _ECCPAS_PSS1BD0         0x01
#define _ECCPAS_PSSBD0          0x01
#define _ECCPAS_P1SSBD1         0x02
#define _ECCPAS_PSS1BD1         0x02
#define _ECCPAS_PSSBD1          0x02
#define _ECCPAS_P1SSAC0         0x04
#define _ECCPAS_PSS1AC0         0x04
#define _ECCPAS_PSSAC0          0x04
#define _ECCPAS_P1SSAC1         0x08
#define _ECCPAS_PSS1AC1         0x08
#define _ECCPAS_PSSAC1          0x08
#define _ECCPAS_CCP1AS0         0x10
#define _ECCPAS_ECCPAS0         0x10
#define _ECCPAS_CCP1AS1         0x20
#define _ECCPAS_ECCPAS1         0x20
#define _ECCPAS_CCP1AS2         0x40
#define _ECCPAS_ECCPAS2         0x40
#define _ECCPAS_CCP1ASE         0x80
#define _ECCPAS_ECCPASE         0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0FB7) __sfr PWM1CON;

typedef union
  {
  struct
    {
    unsigned P1DC0              : 1;
    unsigned P1DC1              : 1;
    unsigned P1DC2              : 1;
    unsigned P1DC3              : 1;
    unsigned P1DC4              : 1;
    unsigned P1DC5              : 1;
    unsigned P1DC6              : 1;
    unsigned P1RSEN             : 1;
    };

  struct
    {
    unsigned PDC0               : 1;
    unsigned PDC1               : 1;
    unsigned PDC2               : 1;
    unsigned PDC3               : 1;
    unsigned PDC4               : 1;
    unsigned PDC5               : 1;
    unsigned PDC6               : 1;
    unsigned PRSEN              : 1;
    };

  struct
    {
    unsigned PDC                : 7;
    unsigned                    : 1;
    };

  struct
    {
    unsigned P1DC               : 7;
    unsigned                    : 1;
    };
  } __PWM1CONbits_t;

extern __at(0x0FB7) volatile __PWM1CONbits_t PWM1CONbits;

#define _P1DC0                  0x01
#define _PDC0                   0x01
#define _P1DC1                  0x02
#define _PDC1                   0x02
#define _P1DC2                  0x04
#define _PDC2                   0x04
#define _P1DC3                  0x08
#define _PDC3                   0x08
#define _P1DC4                  0x10
#define _PDC4                   0x10
#define _P1DC5                  0x20
#define _PDC5                   0x20
#define _P1DC6                  0x40
#define _PDC6                   0x40
#define _P1RSEN                 0x80
#define _PRSEN                  0x80

//==============================================================================


//==============================================================================
//        PWMCON Bits

extern __at(0x0FB7) __sfr PWMCON;

typedef union
  {
  struct
    {
    unsigned P1DC0              : 1;
    unsigned P1DC1              : 1;
    unsigned P1DC2              : 1;
    unsigned P1DC3              : 1;
    unsigned P1DC4              : 1;
    unsigned P1DC5              : 1;
    unsigned P1DC6              : 1;
    unsigned P1RSEN             : 1;
    };

  struct
    {
    unsigned PDC0               : 1;
    unsigned PDC1               : 1;
    unsigned PDC2               : 1;
    unsigned PDC3               : 1;
    unsigned PDC4               : 1;
    unsigned PDC5               : 1;
    unsigned PDC6               : 1;
    unsigned PRSEN              : 1;
    };

  struct
    {
    unsigned PDC                : 7;
    unsigned                    : 1;
    };

  struct
    {
    unsigned P1DC               : 7;
    unsigned                    : 1;
    };
  } __PWMCONbits_t;

extern __at(0x0FB7) volatile __PWMCONbits_t PWMCONbits;

#define _PWMCON_P1DC0           0x01
#define _PWMCON_PDC0            0x01
#define _PWMCON_P1DC1           0x02
#define _PWMCON_PDC1            0x02
#define _PWMCON_P1DC2           0x04
#define _PWMCON_PDC2            0x04
#define _PWMCON_P1DC3           0x08
#define _PWMCON_PDC3            0x08
#define _PWMCON_P1DC4           0x10
#define _PWMCON_PDC4            0x10
#define _PWMCON_P1DC5           0x20
#define _PWMCON_PDC5            0x20
#define _PWMCON_P1DC6           0x40
#define _PWMCON_PDC6            0x40
#define _PWMCON_P1RSEN          0x80
#define _PWMCON_PRSEN           0x80

//==============================================================================


//==============================================================================
//        BAUD1CON Bits

extern __at(0x0FB8) __sfr BAUD1CON;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned CKTXP              : 1;
    unsigned DTRXP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __BAUD1CONbits_t;

extern __at(0x0FB8) volatile __BAUD1CONbits_t BAUD1CONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _CKTXP                  0x10
#define _SCKP                   0x10
#define _DTRXP                  0x20
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x0FB8) __sfr BAUDCON;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned CKTXP              : 1;
    unsigned DTRXP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __BAUDCONbits_t;

extern __at(0x0FB8) volatile __BAUDCONbits_t BAUDCONbits;

#define _BAUDCON_ABDEN          0x01
#define _BAUDCON_WUE            0x02
#define _BAUDCON_BRG16          0x08
#define _BAUDCON_CKTXP          0x10
#define _BAUDCON_SCKP           0x10
#define _BAUDCON_DTRXP          0x20
#define _BAUDCON_RCIDL          0x40
#define _BAUDCON_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x0FB8) __sfr BAUDCON1;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned CKTXP              : 1;
    unsigned DTRXP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __BAUDCON1bits_t;

extern __at(0x0FB8) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _BAUDCON1_ABDEN         0x01
#define _BAUDCON1_WUE           0x02
#define _BAUDCON1_BRG16         0x08
#define _BAUDCON1_CKTXP         0x10
#define _BAUDCON1_SCKP          0x10
#define _BAUDCON1_DTRXP         0x20
#define _BAUDCON1_RCIDL         0x40
#define _BAUDCON1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        BAUDCTL Bits

extern __at(0x0FB8) __sfr BAUDCTL;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned CKTXP              : 1;
    unsigned DTRXP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __BAUDCTLbits_t;

extern __at(0x0FB8) volatile __BAUDCTLbits_t BAUDCTLbits;

#define _BAUDCTL_ABDEN          0x01
#define _BAUDCTL_WUE            0x02
#define _BAUDCTL_BRG16          0x08
#define _BAUDCTL_CKTXP          0x10
#define _BAUDCTL_SCKP           0x10
#define _BAUDCTL_DTRXP          0x20
#define _BAUDCTL_RCIDL          0x40
#define _BAUDCTL_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        PSTR1CON Bits

extern __at(0x0FB9) __sfr PSTR1CON;

typedef struct
  {
  unsigned STR1A                : 1;
  unsigned STR1B                : 1;
  unsigned STR1C                : 1;
  unsigned STR1D                : 1;
  unsigned STR1SYNC             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSTR1CONbits_t;

extern __at(0x0FB9) volatile __PSTR1CONbits_t PSTR1CONbits;

#define _STR1A                  0x01
#define _STR1B                  0x02
#define _STR1C                  0x04
#define _STR1D                  0x08
#define _STR1SYNC               0x10

//==============================================================================


//==============================================================================
//        PSTRCON Bits

extern __at(0x0FB9) __sfr PSTRCON;

typedef struct
  {
  unsigned STR1A                : 1;
  unsigned STR1B                : 1;
  unsigned STR1C                : 1;
  unsigned STR1D                : 1;
  unsigned STR1SYNC             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSTRCONbits_t;

extern __at(0x0FB9) volatile __PSTRCONbits_t PSTRCONbits;

#define _PSTRCON_STR1A          0x01
#define _PSTRCON_STR1B          0x02
#define _PSTRCON_STR1C          0x04
#define _PSTRCON_STR1D          0x08
#define _PSTRCON_STR1SYNC       0x10

//==============================================================================


//==============================================================================
//        T2CON Bits

extern __at(0x0FBA) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0FBA) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================

extern __at(0x0FBB) __sfr PR2;
extern __at(0x0FBC) __sfr TMR2;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0FBD) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0FBD) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _DC1B1                  0x20
#define _P1M0                   0x40
#define _P1M1                   0x80

//==============================================================================

extern __at(0x0FBE) __sfr CCPR1;
extern __at(0x0FBE) __sfr CCPR1L;
extern __at(0x0FBF) __sfr CCPR1H;

//==============================================================================
//        ADCON2 Bits

extern __at(0x0FC0) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ACQT0              : 1;
    unsigned ACQT1              : 1;
    unsigned ACQT2              : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADCS               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ACQT               : 3;
    unsigned                    : 2;
    };
  } __ADCON2bits_t;

extern __at(0x0FC0) volatile __ADCON2bits_t ADCON2bits;

#define _ADCS0                  0x01
#define _ADCS1                  0x02
#define _ADCS2                  0x04
#define _ACQT0                  0x08
#define _ACQT1                  0x10
#define _ACQT2                  0x20
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x0FC1) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned NVCFG0             : 1;
    unsigned NVCFG1             : 1;
    unsigned PVCFG0             : 1;
    unsigned PVCFG1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL            : 1;
    };

  struct
    {
    unsigned NVCFG              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PVCFG              : 2;
    unsigned                    : 4;
    };
  } __ADCON1bits_t;

extern __at(0x0FC1) volatile __ADCON1bits_t ADCON1bits;

#define _NVCFG0                 0x01
#define _NVCFG1                 0x02
#define _PVCFG0                 0x04
#define _PVCFG1                 0x08
#define _TRIGSEL                0x80

//==============================================================================


//==============================================================================
//        ADCON0 Bits

extern __at(0x0FC2) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned DONE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x0FC2) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _GO                     0x02
#define _DONE                   0x02
#define _NOT_DONE               0x02
#define _GO_DONE                0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40

//==============================================================================

extern __at(0x0FC3) __sfr ADRES;
extern __at(0x0FC3) __sfr ADRESL;
extern __at(0x0FC4) __sfr ADRESH;

//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0FC5) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0FC5) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0FC5) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0FC5) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0FC6) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0FC6) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0FC6) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0FC6) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1STAT Bits

extern __at(0x0FC7) __sfr SSP1STAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSP1STATbits_t;

extern __at(0x0FC7) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _R                      0x04
#define _NOT_W                  0x04
#define _R_W                    0x04
#define _NOT_WRITE              0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _D                      0x20
#define _NOT_A                  0x20
#define _D_A                    0x20
#define _NOT_ADDRESS            0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0FC7) __sfr SSPSTAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPSTATbits_t;

extern __at(0x0FC7) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_R              0x04
#define _SSPSTAT_NOT_W          0x04
#define _SSPSTAT_R_W            0x04
#define _SSPSTAT_NOT_WRITE      0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_D              0x20
#define _SSPSTAT_NOT_A          0x20
#define _SSPSTAT_D_A            0x20
#define _SSPSTAT_NOT_ADDRESS    0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================

extern __at(0x0FC8) __sfr SSP1ADD;
extern __at(0x0FC8) __sfr SSPADD;
extern __at(0x0FC9) __sfr SSP1BUF;
extern __at(0x0FC9) __sfr SSPBUF;

//==============================================================================
//        SSP1MSK Bits

extern __at(0x0FCA) __sfr SSP1MSK;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSP1MSKbits_t;

extern __at(0x0FCA) volatile __SSP1MSKbits_t SSP1MSKbits;

#define _MSK0                   0x01
#define _MSK1                   0x02
#define _MSK2                   0x04
#define _MSK3                   0x08
#define _MSK4                   0x10
#define _MSK5                   0x20
#define _MSK6                   0x40
#define _MSK7                   0x80

//==============================================================================


//==============================================================================
//        SSPMSK Bits

extern __at(0x0FCA) __sfr SSPMSK;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSPMSKbits_t;

extern __at(0x0FCA) volatile __SSPMSKbits_t SSPMSKbits;

#define _SSPMSK_MSK0            0x01
#define _SSPMSK_MSK1            0x02
#define _SSPMSK_MSK2            0x04
#define _SSPMSK_MSK3            0x08
#define _SSPMSK_MSK4            0x10
#define _SSPMSK_MSK5            0x20
#define _SSPMSK_MSK6            0x40
#define _SSPMSK_MSK7            0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0FCB) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0FCB) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================


//==============================================================================
//        SSPCON3 Bits

extern __at(0x0FCB) __sfr SSPCON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSPCON3bits_t;

extern __at(0x0FCB) volatile __SSPCON3bits_t SSPCON3bits;

#define _SSPCON3_DHEN           0x01
#define _SSPCON3_AHEN           0x02
#define _SSPCON3_SBCDE          0x04
#define _SSPCON3_SDAHT          0x08
#define _SSPCON3_BOEN           0x10
#define _SSPCON3_SCIE           0x20
#define _SSPCON3_PCIE           0x40
#define _SSPCON3_ACKTIM         0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0FCC) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1G_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0FCC) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_DONE         0x08
#define _T1G_DONE               0x08
#define _T1GGO                  0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================


//==============================================================================
//        T1CON Bits

extern __at(0x0FCD) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned T1RD16             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1SOSCEN           : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned RD16               : 1;
    unsigned T1SYNC             : 1;
    unsigned T1OSCEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0FCD) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _T1RD16                 0x02
#define _RD16                   0x02
#define _NOT_T1SYNC             0x04
#define _T1SYNC                 0x04
#define _T1SOSCEN               0x08
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================

extern __at(0x0FCE) __sfr TMR1;
extern __at(0x0FCE) __sfr TMR1L;
extern __at(0x0FCF) __sfr TMR1H;

//==============================================================================
//        RCON Bits

extern __at(0x0FD0) __sfr RCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned NOT_RI             : 1;
    unsigned                    : 1;
    unsigned SBOREN             : 1;
    unsigned IPEN               : 1;
    };

  struct
    {
    unsigned BOR                : 1;
    unsigned POR                : 1;
    unsigned PD                 : 1;
    unsigned TO                 : 1;
    unsigned RI                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCONbits_t;

extern __at(0x0FD0) volatile __RCONbits_t RCONbits;

#define _NOT_BOR                0x01
#define _BOR                    0x01
#define _NOT_POR                0x02
#define _POR                    0x02
#define _NOT_PD                 0x04
#define _PD                     0x04
#define _NOT_TO                 0x08
#define _TO                     0x08
#define _NOT_RI                 0x10
#define _RI                     0x10
#define _SBOREN                 0x40
#define _IPEN                   0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0FD1) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SWDTE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __WDTCONbits_t;

extern __at(0x0FD1) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _SWDTE                  0x01

//==============================================================================


//==============================================================================
//        OSCCON2 Bits

extern __at(0x0FD2) __sfr OSCCON2;

typedef struct
  {
  unsigned LFIOFS               : 1;
  unsigned MFIOFS               : 1;
  unsigned PRISD                : 1;
  unsigned SOSCGO               : 1;
  unsigned MFIOSEL              : 1;
  unsigned                      : 1;
  unsigned SOSCRUN              : 1;
  unsigned PLLRDY               : 1;
  } __OSCCON2bits_t;

extern __at(0x0FD2) volatile __OSCCON2bits_t OSCCON2bits;

#define _LFIOFS                 0x01
#define _MFIOFS                 0x02
#define _PRISD                  0x04
#define _SOSCGO                 0x08
#define _MFIOSEL                0x10
#define _SOSCRUN                0x40
#define _PLLRDY                 0x80

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0FD3) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned HFIOFS             : 1;
    unsigned OSTS               : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IDLEN              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned IOFS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 3;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0FD3) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _HFIOFS                 0x04
#define _IOFS                   0x04
#define _OSTS                   0x08
#define _IRCF0                  0x10
#define _IRCF1                  0x20
#define _IRCF2                  0x40
#define _IDLEN                  0x80

//==============================================================================


//==============================================================================
//        T0CON Bits

extern __at(0x0FD5) __sfr T0CON;

typedef union
  {
  struct
    {
    unsigned T0PS0              : 1;
    unsigned T0PS1              : 1;
    unsigned T0PS2              : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned T08BIT             : 1;
    unsigned TMR0ON             : 1;
    };

  struct
    {
    unsigned T0PS               : 3;
    unsigned                    : 5;
    };
  } __T0CONbits_t;

extern __at(0x0FD5) volatile __T0CONbits_t T0CONbits;

#define _T0PS0                  0x01
#define _T0PS1                  0x02
#define _T0PS2                  0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _T08BIT                 0x40
#define _TMR0ON                 0x80

//==============================================================================

extern __at(0x0FD6) __sfr TMR0;
extern __at(0x0FD6) __sfr TMR0L;
extern __at(0x0FD7) __sfr TMR0H;

//==============================================================================
//        STATUS Bits

extern __at(0x0FD8) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned OV                   : 1;
  unsigned N                    : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0FD8) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _OV                     0x08
#define _N                      0x10

//==============================================================================

extern __at(0x0FD9) __sfr FSR2L;
extern __at(0x0FDA) __sfr FSR2H;
extern __at(0x0FDB) __sfr PLUSW2;
extern __at(0x0FDC) __sfr PREINC2;
extern __at(0x0FDD) __sfr POSTDEC2;
extern __at(0x0FDE) __sfr POSTINC2;
extern __at(0x0FDF) __sfr INDF2;
extern __at(0x0FE0) __sfr BSR;
extern __at(0x0FE1) __sfr FSR1L;
extern __at(0x0FE2) __sfr FSR1H;
extern __at(0x0FE3) __sfr PLUSW1;
extern __at(0x0FE4) __sfr PREINC1;
extern __at(0x0FE5) __sfr POSTDEC1;
extern __at(0x0FE6) __sfr POSTINC1;
extern __at(0x0FE7) __sfr INDF1;
extern __at(0x0FE8) __sfr WREG;
extern __at(0x0FE9) __sfr FSR0L;
extern __at(0x0FEA) __sfr FSR0H;
extern __at(0x0FEB) __sfr PLUSW0;
extern __at(0x0FEC) __sfr PREINC0;
extern __at(0x0FED) __sfr POSTDEC0;
extern __at(0x0FEE) __sfr POSTINC0;
extern __at(0x0FEF) __sfr INDF0;

//==============================================================================
//        INTCON3 Bits

extern __at(0x0FF0) __sfr INTCON3;

typedef union
  {
  struct
    {
    unsigned INT1IF             : 1;
    unsigned INT2IF             : 1;
    unsigned                    : 1;
    unsigned INT1IE             : 1;
    unsigned INT2IE             : 1;
    unsigned                    : 1;
    unsigned INT1IP             : 1;
    unsigned INT2IP             : 1;
    };

  struct
    {
    unsigned INT1F              : 1;
    unsigned INT2F              : 1;
    unsigned                    : 1;
    unsigned INT1E              : 1;
    unsigned INT2E              : 1;
    unsigned                    : 1;
    unsigned INT1P              : 1;
    unsigned INT2P              : 1;
    };
  } __INTCON3bits_t;

extern __at(0x0FF0) volatile __INTCON3bits_t INTCON3bits;

#define _INT1IF                 0x01
#define _INT1F                  0x01
#define _INT2IF                 0x02
#define _INT2F                  0x02
#define _INT1IE                 0x08
#define _INT1E                  0x08
#define _INT2IE                 0x10
#define _INT2E                  0x10
#define _INT1IP                 0x40
#define _INT1P                  0x40
#define _INT2IP                 0x80
#define _INT2P                  0x80

//==============================================================================


//==============================================================================
//        INTCON2 Bits

extern __at(0x0FF1) __sfr INTCON2;

typedef union
  {
  struct
    {
    unsigned RBIP               : 1;
    unsigned                    : 1;
    unsigned TMR0IP             : 1;
    unsigned                    : 1;
    unsigned INTEDG2            : 1;
    unsigned INTEDG1            : 1;
    unsigned INTEDG0            : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RBPU               : 1;
    };
  } __INTCON2bits_t;

extern __at(0x0FF1) volatile __INTCON2bits_t INTCON2bits;

#define _RBIP                   0x01
#define _TMR0IP                 0x04
#define _INTEDG2                0x10
#define _INTEDG1                0x20
#define _INTEDG0                0x40
#define _NOT_RBPU               0x80
#define _RBPU                   0x80

//==============================================================================


//==============================================================================
//        INTCON Bits

extern __at(0x0FF2) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INT0IF             : 1;
    unsigned TMR0IF             : 1;
    unsigned RBIE               : 1;
    unsigned INT0IE             : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE_GIEL          : 1;
    unsigned GIE_GIEH           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT0F              : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned INT0E              : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GIEL               : 1;
    unsigned GIEH               : 1;
    };
  } __INTCONbits_t;

extern __at(0x0FF2) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INT0IF                 0x02
#define _INT0F                  0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _RBIE                   0x08
#define _INT0IE                 0x10
#define _INT0E                  0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE_GIEL              0x40
#define _PEIE                   0x40
#define _GIEL                   0x40
#define _GIE_GIEH               0x80
#define _GIE                    0x80
#define _GIEH                   0x80

//==============================================================================

extern __at(0x0FF3) __sfr PROD;
extern __at(0x0FF3) __sfr PRODL;
extern __at(0x0FF4) __sfr PRODH;
extern __at(0x0FF5) __sfr TABLAT;
extern __at(0x0FF6) __sfr TBLPTR;
extern __at(0x0FF6) __sfr TBLPTRL;
extern __at(0x0FF7) __sfr TBLPTRH;
extern __at(0x0FF8) __sfr TBLPTRU;
extern __at(0x0FF9) __sfr PC;
extern __at(0x0FF9) __sfr PCL;
extern __at(0x0FFA) __sfr PCLATH;
extern __at(0x0FFB) __sfr PCLATU;

//==============================================================================
//        STKPTR Bits

extern __at(0x0FFC) __sfr STKPTR;

typedef union
  {
  struct
    {
    unsigned STKPTR0            : 1;
    unsigned STKPTR1            : 1;
    unsigned STKPTR2            : 1;
    unsigned STKPTR3            : 1;
    unsigned STKPTR4            : 1;
    unsigned                    : 1;
    unsigned STKUNF             : 1;
    unsigned STKFUL             : 1;
    };

  struct
    {
    unsigned SP0                : 1;
    unsigned SP1                : 1;
    unsigned SP2                : 1;
    unsigned SP3                : 1;
    unsigned SP4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned STKOVF             : 1;
    };

  struct
    {
    unsigned STKPTR             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned SP                 : 5;
    unsigned                    : 3;
    };
  } __STKPTRbits_t;

extern __at(0x0FFC) volatile __STKPTRbits_t STKPTRbits;

#define _STKPTR0                0x01
#define _SP0                    0x01
#define _STKPTR1                0x02
#define _SP1                    0x02
#define _STKPTR2                0x04
#define _SP2                    0x04
#define _STKPTR3                0x08
#define _SP3                    0x08
#define _STKPTR4                0x10
#define _SP4                    0x10
#define _STKUNF                 0x40
#define _STKFUL                 0x80
#define _STKOVF                 0x80

//==============================================================================

extern __at(0x0FFD) __sfr TOS;
extern __at(0x0FFD) __sfr TOSL;
extern __at(0x0FFE) __sfr TOSH;
extern __at(0x0FFF) __sfr TOSU;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define __CONFIG1H              0x300001
#define __CONFIG2L              0x300002
#define __CONFIG2H              0x300003
#define __CONFIG3H              0x300005
#define __CONFIG4L              0x300006
#define __CONFIG5L              0x300008
#define __CONFIG5H              0x300009
#define __CONFIG6L              0x30000A
#define __CONFIG6H              0x30000B
#define __CONFIG7L              0x30000C
#define __CONFIG7H              0x30000D

//----------------------------- CONFIG1H Options -------------------------------

#define _FOSC_LP_1H             0xF0    // LP oscillator.
#define _FOSC_XT_1H             0xF1    // XT oscillator.
#define _FOSC_HSHP_1H           0xF2    // HS oscillator (high power > 16 MHz).
#define _FOSC_HSMP_1H           0xF3    // HS oscillator (medium power 4-16 MHz).
#define _FOSC_ECHP_1H           0xF4    // EC oscillator, CLKOUT function on OSC2 (high power, >16 MHz).
#define _FOSC_ECHPIO6_1H        0xF5    // EC oscillator (high power, >16 MHz).
#define _FOSC_RC_1H             0xF6    // External RC oscillator, CLKOUT function on OSC2.
#define _FOSC_RCIO6_1H          0xF7    // External RC oscillator.
#define _FOSC_INTIO67_1H        0xF8    // Internal oscillator block.
#define _FOSC_INTIO7_1H         0xF9    // Internal oscillator block, CLKOUT function on OSC2.
#define _FOSC_ECMP_1H           0xFA    // EC oscillator, CLKOUT function on OSC2 (medium power, 500 kHz-16 MHz).
#define _FOSC_ECMPIO6_1H        0xFB    // EC oscillator (medium power, 500 kHz-16 MHz).
#define _FOSC_ECLP_1H           0xFC    // EC oscillator, CLKOUT function on OSC2 (low power, <500 kHz).
#define _FOSC_ECLPIO6_1H        0xFD    // EC oscillator (low power, <500 kHz).
#define _PLLCFG_OFF_1H          0xEF    // Oscillator used directly.
#define _PLLCFG_ON_1H           0xFF    // Oscillator multiplied by 4.
#define _PRICLKEN_OFF_1H        0xDF    // Primary clock can be disabled by software.
#define _PRICLKEN_ON_1H         0xFF    // Primary clock enabled.
#define _FCMEN_OFF_1H           0xBF    // Fail-Safe Clock Monitor disabled.
#define _FCMEN_ON_1H            0xFF    // Fail-Safe Clock Monitor enabled.
#define _IESO_OFF_1H            0x7F    // Oscillator Switchover mode disabled.
#define _IESO_ON_1H             0xFF    // Oscillator Switchover mode enabled.

//----------------------------- CONFIG2L Options -------------------------------

#define _PWRTEN_ON_2L           0xFE    // Power up timer enabled.
#define _PWRTEN_OFF_2L          0xFF    // Power up timer disabled.
#define _BOREN_OFF_2L           0xF9    // Brown-out Reset disabled in hardware and software.
#define _BOREN_ON_2L            0xFB    // Brown-out Reset enabled and controlled by software (SBOREN is enabled).
#define _BOREN_NOSLP_2L         0xFD    // Brown-out Reset enabled in hardware only and disabled in Sleep mode (SBOREN is disabled).
#define _BOREN_SBORDIS_2L       0xFF    // Brown-out Reset enabled in hardware only (SBOREN is disabled).
#define _BORV_285_2L            0xE7    // VBOR set to 2.85 V nominal.
#define _BORV_250_2L            0xEF    // VBOR set to 2.50 V nominal.
#define _BORV_220_2L            0xF7    // VBOR set to 2.20 V nominal.
#define _BORV_190_2L            0xFF    // VBOR set to 1.90 V nominal.

//----------------------------- CONFIG2H Options -------------------------------

#define _WDTEN_OFF_2H           0xFC    // Watch dog timer is always disabled. SWDTEN has no effect.
#define _WDTEN_NOSLP_2H         0xFD    // WDT is disabled in sleep, otherwise enabled. SWDTEN bit has no effect.
#define _WDTEN_SWON_2H          0xFE    // WDT is controlled by SWDTEN bit of the WDTCON register.
#define _WDTEN_ON_2H            0xFF    // WDT is always enabled. SWDTEN bit has no effect.
#define _WDTPS_1_2H             0xC3    // 1:1.
#define _WDTPS_2_2H             0xC7    // 1:2.
#define _WDTPS_4_2H             0xCB    // 1:4.
#define _WDTPS_8_2H             0xCF    // 1:8.
#define _WDTPS_16_2H            0xD3    // 1:16.
#define _WDTPS_32_2H            0xD7    // 1:32.
#define _WDTPS_64_2H            0xDB    // 1:64.
#define _WDTPS_128_2H           0xDF    // 1:128.
#define _WDTPS_256_2H           0xE3    // 1:256.
#define _WDTPS_512_2H           0xE7    // 1:512.
#define _WDTPS_1024_2H          0xEB    // 1:1024.
#define _WDTPS_2048_2H          0xEF    // 1:2048.
#define _WDTPS_4096_2H          0xF3    // 1:4096.
#define _WDTPS_8192_2H          0xF7    // 1:8192.
#define _WDTPS_16384_2H         0xFB    // 1:16384.
#define _WDTPS_32768_2H         0xFF    // 1:32768.

//----------------------------- CONFIG3H Options -------------------------------

#define _CCP2MX_PORTB3_3H       0xFE    // CCP2 input/output is multiplexed with RB3.
#define _CCP2MX_PORTC1_3H       0xFF    // CCP2 input/output is multiplexed with RC1.
#define _PBADEN_OFF_3H          0xFD    // PORTB<5:0> pins are configured as digital I/O on Reset.
#define _PBADEN_ON_3H           0xFF    // PORTB<5:0> pins are configured as analog input channels on Reset.
#define _CCP3MX_PORTC6_3H       0xFB    // P3A/CCP3 input/output is mulitplexed with RC6.
#define _CCP3MX_PORTB5_3H       0xFF    // P3A/CCP3 input/output is multiplexed with RB5.
#define _HFOFST_OFF_3H          0xF7    // HFINTOSC output and ready status are delayed by the oscillator stable status.
#define _HFOFST_ON_3H           0xFF    // HFINTOSC output and ready status are not delayed by the oscillator stable status.
#define _T3CMX_PORTB5_3H        0xEF    // T3CKI is on RB5.
#define _T3CMX_PORTC0_3H        0xFF    // T3CKI is on RC0.
#define _P2BMX_PORTC0_3H        0xDF    // P2B is on RC0.
#define _P2BMX_PORTB5_3H        0xFF    // P2B is on RB5.
#define _MCLRE_INTMCLR_3H       0x7F    // RE3 input pin enabled; MCLR disabled.
#define _MCLRE_EXTMCLR_3H       0xFF    // MCLR pin enabled, RE3 input pin disabled.

//----------------------------- CONFIG4L Options -------------------------------

#define _STVREN_OFF_4L          0xFE    // Stack full/underflow will not cause Reset.
#define _STVREN_ON_4L           0xFF    // Stack full/underflow will cause Reset.
#define _LVP_OFF_4L             0xFB    // Single-Supply ICSP disabled.
#define _LVP_ON_4L              0xFF    // Single-Supply ICSP enabled if MCLRE is also 1.
#define _XINST_OFF_4L           0xBF    // Instruction set extension and Indexed Addressing mode disabled (Legacy mode).
#define _XINST_ON_4L            0xFF    // Instruction set extension and Indexed Addressing mode enabled.
#define _DEBUG_ON_4L            0x7F    // Enabled.
#define _DEBUG_OFF_4L           0xFF    // Disabled.

//----------------------------- CONFIG5L Options -------------------------------

#define _CP0_ON_5L              0xFE    // Block 0 (000800-003FFFh) code-protected.
#define _CP0_OFF_5L             0xFF    // Block 0 (000800-003FFFh) not code-protected.
#define _CP1_ON_5L              0xFD    // Block 1 (004000-007FFFh) code-protected.
#define _CP1_OFF_5L             0xFF    // Block 1 (004000-007FFFh) not code-protected.
#define _CP2_ON_5L              0xFB    // Block 2 (008000-00BFFFh) code-protected.
#define _CP2_OFF_5L             0xFF    // Block 2 (008000-00BFFFh) not code-protected.
#define _CP3_ON_5L              0xF7    // Block 3 (00C000-00FFFFh) code-protected.
#define _CP3_OFF_5L             0xFF    // Block 3 (00C000-00FFFFh) not code-protected.

//----------------------------- CONFIG5H Options -------------------------------

#define _CPB_ON_5H              0xBF    // Boot block (000000-0007FFh) code-protected.
#define _CPB_OFF_5H             0xFF    // Boot block (000000-0007FFh) not code-protected.
#define _CPD_ON_5H              0x7F    // Data EEPROM code-protected.
#define _CPD_OFF_5H             0xFF    // Data EEPROM not code-protected.

//----------------------------- CONFIG6L Options -------------------------------

#define _WRT0_ON_6L             0xFE    // Block 0 (000800-003FFFh) write-protected.
#define _WRT0_OFF_6L            0xFF    // Block 0 (000800-003FFFh) not write-protected.
#define _WRT1_ON_6L             0xFD    // Block 1 (004000-007FFFh) write-protected.
#define _WRT1_OFF_6L            0xFF    // Block 1 (004000-007FFFh) not write-protected.
#define _WRT2_ON_6L             0xFB    // Block 2 (008000-00BFFFh) write-protected.
#define _WRT2_OFF_6L            0xFF    // Block 2 (008000-00BFFFh) not write-protected.
#define _WRT3_ON_6L             0xF7    // Block 3 (00C000-00FFFFh) write-protected.
#define _WRT3_OFF_6L            0xFF    // Block 3 (00C000-00FFFFh) not write-protected.

//----------------------------- CONFIG6H Options -------------------------------

#define _WRTC_ON_6H             0xDF    // Configuration registers (300000-3000FFh) write-protected.
#define _WRTC_OFF_6H            0xFF    // Configuration registers (300000-3000FFh) not write-protected.
#define _WRTB_ON_6H             0xBF    // Boot Block (000000-0007FFh) write-protected.
#define _WRTB_OFF_6H            0xFF    // Boot Block (000000-0007FFh) not write-protected.
#define _WRTD_ON_6H             0x7F    // Data EEPROM write-protected.
#define _WRTD_OFF_6H            0xFF    // Data EEPROM not write-protected.

//----------------------------- CONFIG7L Options -------------------------------

#define _EBTR0_ON_7L            0xFE    // Block 0 (000800-003FFFh) protected from table reads executed in other blocks.
#define _EBTR0_OFF_7L           0xFF    // Block 0 (000800-003FFFh) not protected from table reads executed in other blocks.
#define _EBTR1_ON_7L            0xFD    // Block 1 (004000-007FFFh) protected from table reads executed in other blocks.
#define _EBTR1_OFF_7L           0xFF    // Block 1 (004000-007FFFh) not protected from table reads executed in other blocks.
#define _EBTR2_ON_7L            0xFB    // Block 2 (008000-00BFFFh) protected from table reads executed in other blocks.
#define _EBTR2_OFF_7L           0xFF    // Block 2 (008000-00BFFFh) not protected from table reads executed in other blocks.
#define _EBTR3_ON_7L            0xF7    // Block 3 (00C000-00FFFFh) protected from table reads executed in other blocks.
#define _EBTR3_OFF_7L           0xFF    // Block 3 (00C000-00FFFFh) not protected from table reads executed in other blocks.

//----------------------------- CONFIG7H Options -------------------------------

#define _EBTRB_ON_7H            0xBF    // Boot Block (000000-0007FFh) protected from table reads executed in other blocks.
#define _EBTRB_OFF_7H           0xFF    // Boot Block (000000-0007FFh) not protected from table reads executed in other blocks.

//==============================================================================

#define __DEVID1                0x3FFFFE
#define __DEVID2                0x3FFFFF

#define __IDLOC0                0x200000
#define __IDLOC1                0x200001
#define __IDLOC2                0x200002
#define __IDLOC3                0x200003
#define __IDLOC4                0x200004
#define __IDLOC5                0x200005
#define __IDLOC6                0x200006
#define __IDLOC7                0x200007

#endif // #ifndef __PIC18LF26K22_H__
