/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3.fontface;

import java.util.Arrays;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.external.OpenTypeLanguageSystemTag;

public class CssFontLanguageOverride
extends org.w3c.css.properties.css.fontface.CssFontLanguageOverride {
    public static final CssIdent[] allowed_values;

    public static CssIdent getAllowedIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssFontLanguageOverride() {
        this.value = initial;
    }

    public CssFontLanguageOverride(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 1) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        switch (val.getType()) {
            case 1: {
                CssString s = val.getString();
                int l = s.toString().length();
                if (l < 4 || l > 6) {
                    throw new InvalidParamException("value", expression.getValue().toString(), this.getPropertyName(), ac);
                }
                String tag = s.toString().substring(1, l - 1).toUpperCase();
                switch (tag.length()) {
                    case 1: {
                        tag = tag.concat("   ");
                        break;
                    }
                    case 2: {
                        tag = tag.concat("  ");
                        break;
                    }
                    case 3: {
                        tag = tag.concat(" ");
                        break;
                    }
                }
                int idx = Arrays.binarySearch(OpenTypeLanguageSystemTag.tags, tag);
                if (idx < 0) {
                    throw new InvalidParamException("value", expression.getValue().toString(), this.getPropertyName(), ac);
                }
                idx = Arrays.binarySearch(OpenTypeLanguageSystemTag.deprecated_tags, tag);
                if (idx >= 0) {
                    ac.getFrame().addWarning("deprecated", tag);
                }
                this.value = val;
                break;
            }
            case 0: {
                if (CssFontLanguageOverride.getAllowedIdent(val.getIdent()) != null) {
                    this.value = val;
                    break;
                }
            }
            default: {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        }
        expression.next();
    }

    public CssFontLanguageOverride(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] _allowed_values = new String[]{"normal"};
        allowed_values = new CssIdent[_allowed_values.length];
        int i = 0;
        for (String s : _allowed_values) {
            CssFontLanguageOverride.allowed_values[i++] = CssIdent.getIdent(s);
        }
    }
}

