/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssContain
extends org.w3c.css.properties.css.CssContain {
    public static final CssIdent[] allowed_single_values;
    public static final CssIdent[] allowed_multiple_values;
    public static final CssIdent auto;

    public static CssIdent getAllowedSingleIdent(CssIdent ident) {
        for (CssIdent id : allowed_single_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getAllowedMultipleIdent(CssIdent ident) {
        for (CssIdent id : allowed_multiple_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssContain() {
        this.value = initial;
    }

    public CssContain(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        boolean got_single = false;
        this.setByUser();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        ArrayList<CssIdent> idvalues = new ArrayList<CssIdent>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() != 0) {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
            CssIdent id = val.getIdent();
            if (CssIdent.isCssWide(id)) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
                values.add(val);
                expression.next();
                continue;
            }
            if (CssContain.getAllowedSingleIdent(id) != null) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
                values.add(val);
                expression.next();
                continue;
            }
            CssIdent ident = CssContain.getAllowedMultipleIdent(id);
            if (ident == null) {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
            if (idvalues.contains(ident)) {
                throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
            }
            idvalues.add(ident);
            values.add(val);
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.valueOf(op), this.getPropertyName(), ac);
            }
            expression.next();
        }
        this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    public CssContain(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        auto = CssIdent.getIdent("auto");
        String[] _allowed_single_values = new String[]{"none", "strict", "content"};
        allowed_single_values = new CssIdent[_allowed_single_values.length];
        int i = 0;
        for (String s : _allowed_single_values) {
            CssContain.allowed_single_values[i++] = CssIdent.getIdent(s);
        }
        String[] _allowed_multiple_values = new String[]{"size", "layout", "paint", "style"};
        i = 0;
        allowed_multiple_values = new CssIdent[_allowed_multiple_values.length];
        for (String s : _allowed_multiple_values) {
            CssContain.allowed_multiple_values[i++] = CssIdent.getIdent(s);
        }
    }
}

