/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.error;

import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.UnknownHostException;
import org.w3c.css.error.ErrorReport;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.Utf8Properties;

public class ErrorReportSOAP12
extends ErrorReport {
    private String title;
    private boolean validURI;
    private Exception exception;
    private ApplContext ac;
    private static Utf8Properties messages = new Utf8Properties();
    private PrintWriter out;

    ErrorReportSOAP12(ApplContext ac, String title, String output, Exception e, boolean validURI) {
        this.ac = ac;
        this.exception = e;
        this.validURI = validURI;
        this.title = title;
    }

    @Override
    public void print(PrintWriter out) {
        String report;
        this.out = out;
        String errorMessage = this.exception.getMessage();
        if (this.validURI) {
            report = messages.getProperty("receiver");
            if (this.exception instanceof UnknownHostException) {
                errorMessage = "The host name " + errorMessage + " couldn't be resolved";
            }
        } else {
            report = messages.getProperty("sender");
        }
        this.processError(report, errorMessage, this.title + ' ' + this.exception);
    }

    private void processError(String str, String errorMessage, String details) {
        block7: {
            try {
                int i = 0;
                while ((i = str.indexOf("<!-- #", i)) >= 0) {
                    int lastIndexOfEntity = str.indexOf("-->", i);
                    String entity = str.substring(i + 6, lastIndexOfEntity - 1).toLowerCase();
                    if (entity.equals("reason")) {
                        this.out.print(str.substring(0, i));
                        str = str.substring(lastIndexOfEntity + 3);
                        i = 0;
                        this.out.print(errorMessage);
                        continue;
                    }
                    if (entity.equals("details")) {
                        this.out.print(str.substring(0, i));
                        str = str.substring(lastIndexOfEntity + 3);
                        i = 0;
                        this.out.print(details);
                        continue;
                    }
                    if (entity.equals("charset")) {
                        this.out.print(str.substring(0, i));
                        str = str.substring(lastIndexOfEntity + 3);
                        i = 0;
                        this.out.print(this.ac.getContentEncoding());
                        continue;
                    }
                    i += 6;
                }
                if (str != null) {
                    this.out.print(str);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (str == null) break block7;
                this.out.print(str);
            }
        }
    }

    static {
        try {
            URL url = ErrorReportSOAP12.class.getResource("soaperror.properties");
            InputStream f = url.openStream();
            messages.load(f);
            f.close();
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.error.ErrorReportSOAP12: couldn't load soap error messages properties ");
            System.err.println("  " + e.toString());
        }
    }
}

