/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.appletextendedsecurity;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.appletextendedsecurity.AppletSecurityActions;
import net.sourceforge.jnlp.security.appletextendedsecurity.InvalidLineException;
import net.sourceforge.jnlp.security.appletextendedsecurity.UrlRegEx;

public class UnsignedAppletActionEntry {
    private final AppletSecurityActions appletSecurityActions;
    private Date timeStamp;
    private UrlRegEx documentBase;
    private UrlRegEx codeBase;
    private List<String> archives;

    public static UnsignedAppletActionEntry createFromString(String s) {
        String[] split = s.split("\\s+");
        UnsignedAppletActionEntry nw = new UnsignedAppletActionEntry(AppletSecurityActions.fromString(split[0]), new Date(new Long(split[1])), UrlRegEx.exact(split[2]), null, null);
        if (split.length > 3) {
            nw.setCodeBase(UrlRegEx.exact(split[3]));
        }
        if (split.length > 4) {
            nw.setArchives(UnsignedAppletActionEntry.createArchivesList(s.substring(s.lastIndexOf(split[3]) + split[3].length()).trim()));
        }
        return nw;
    }

    public UnsignedAppletActionEntry(AppletSecurityActions unsignedAppletAction, Date timeStamp, UrlRegEx documentBase, UrlRegEx codeBase, List<String> archives) {
        this.appletSecurityActions = unsignedAppletAction;
        this.timeStamp = timeStamp;
        this.documentBase = documentBase;
        this.codeBase = codeBase;
        this.archives = archives;
    }

    public String toString() {
        return this.serializeToReadableAndParseableString();
    }

    public void write(Writer bw) throws IOException {
        bw.write(this.serializeToReadableAndParseableString());
    }

    private String serializeToReadableAndParseableString() throws InvalidLineException {
        String s = this.appletSecurityActions.toString() + " " + (this.timeStamp == null ? "1" : Long.valueOf(this.timeStamp.getTime())) + " " + (this.documentBase == null ? "" : this.documentBase.getRegEx()) + " " + (this.codeBase == null ? "" : this.codeBase.getRegEx()) + " " + UnsignedAppletActionEntry.createArchivesString(this.archives);
        if (s.contains("\n") || s.contains("\r") || s.contains("\f")) {
            throw new InvalidLineException("Cant write line with \\n, \\r or \\f");
        }
        return s;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String getLocalisedTimeStamp() {
        return JNLPRuntime.getLocalisedTimeStamp(this.timeStamp);
    }

    public UrlRegEx getDocumentBase() {
        return this.documentBase;
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setDocumentBase(UrlRegEx documentBase) {
        this.documentBase = documentBase;
    }

    public AppletSecurityActions getAppletSecurityActions() {
        return this.appletSecurityActions;
    }

    public UrlRegEx getCodeBase() {
        return this.codeBase;
    }

    public void setCodeBase(UrlRegEx codeBase) {
        this.codeBase = codeBase;
    }

    public List<String> getArchives() {
        return this.archives;
    }

    public void setArchives(List<String> archives) {
        this.archives = archives;
    }

    public static String createArchivesString(List<String> listOfArchives) {
        if (listOfArchives == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < listOfArchives.size(); ++i) {
            String string = listOfArchives.get(i);
            if (string.trim().isEmpty()) continue;
            sb.append(string);
            if (i == listOfArchives.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static List<String> createArchivesList(String commedArchives) {
        if (commedArchives == null) {
            return null;
        }
        if (commedArchives.trim().isEmpty()) {
            return null;
        }
        String[] items = commedArchives.trim().split(",");
        ArrayList<String> r = new ArrayList<String>(items.length);
        for (int i = 0; i < items.length; ++i) {
            String string = items[i];
            if (string.trim().isEmpty()) continue;
            r.add(string);
        }
        return r;
    }
}

