/*
    Copyright (c) 2002-2003, Intel Corporation. All rights reserved.
    Created by:  majid.awad REMOVE-THIS AT intel DOT com
    This file is licensed under the GPL license.  For the full content 
    of this license, see the COPYING file at the top level of this 
    source tree.
 */

/*
   sem_open test case that attempts to open a new semaphoree, and then 
  lock it with sem_wait.  Making sure the semaphore is locked. 
 */

#include <sys/types.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <semaphore.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "posixtest.h"

#define TEST "1-3"
#define FUNCTION "sem_open"
#define ERROR_PREFIX "unexpected error: " FUNCTION " " TEST ": "


int main()
{
	sem_t   *mysemp;
	char semname[50];
	int lock_status;

	sprintf(semname, "/" FUNCTION "_" TEST "_%d", getpid());

	mysemp = sem_open(semname, O_CREAT, 0777, 1);
        if( mysemp == SEM_FAILED || mysemp == NULL ) {
                perror(ERROR_PREFIX "sem_open");
                return PTS_UNRESOLVED;
        }

	lock_status = sem_wait(mysemp);

	/* Checking if sem_wait has a value returned. From sem_open */
	if (lock_status == 0)
	{
		puts("TEST PASSED");
		sem_close(mysemp);
		sem_unlink(semname);
		return PTS_PASS;
	}
	else
	{
		puts("TEST FAILED");
		return PTS_FAIL;
	}
}
